/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;

public class GroovyNestedAssignmentInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyNestedAssignmentInspection", "getGroupDisplayName"));
        }
        return "Assignment issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Nested assignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyNestedAssignmentInspection", "getDisplayName"));
        }
        return "Nested assignment";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Nested assignment expression #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyNestedAssignmentInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression grAssignmentExpression) {
            super.visitAssignmentExpression(grAssignmentExpression);
            PsiElement parent = grAssignmentExpression.getParent();
            if (!(parent instanceof GrAssignmentExpression)) {
                return;
            }
            this.registerError(grAssignmentExpression);
        }
    }
}

