/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dgm.GroovyExtensionProvider;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class DGMMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GlobalSearchScope scope;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        Project project = place.getProject();
        ConcurrentMap map = (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<ConcurrentMap<GlobalSearchScope, List<GdkMethodHolder>>>(){

            @Nullable
            public CachedValueProvider.Result<ConcurrentMap<GlobalSearchScope, List<GdkMethodHolder>>> compute() {
                ConcurrentMap value = ContainerUtil.createConcurrentSoftValueMap();
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        List<GdkMethodHolder> gdkMethods = (List<GdkMethodHolder>)map.get(scope = place.getResolveScope());
        if (gdkMethods == null) {
            gdkMethods = DGMMemberContributor.calcGdkMethods(project, scope);
            map.put(scope, gdkMethods);
        }
        for (GdkMethodHolder holder : gdkMethods) {
            if (holder.processMethods(processor, state, qualifierType, project)) continue;
            return;
        }
    }

    @NotNull
    private static List<GdkMethodHolder> calcGdkMethods(Project project, GlobalSearchScope resolveScope) {
        PsiClass clazz;
        ArrayList gdkMethods = ContainerUtil.newArrayList();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Couple<List<String>> extensions = GroovyExtensionProvider.getInstance(project).collectExtensions(resolveScope);
        for (String category : (List)extensions.getFirst()) {
            clazz = facade.findClass(category, resolveScope);
            if (clazz == null) continue;
            gdkMethods.add(GdkMethodHolder.getHolderForClass(clazz, false, resolveScope));
        }
        for (String category : (List)extensions.getSecond()) {
            clazz = facade.findClass(category, resolveScope);
            if (clazz == null) continue;
            gdkMethods.add(GdkMethodHolder.getHolderForClass(clazz, true, resolveScope));
        }
        ArrayList arrayList = gdkMethods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "calcGdkMethods"));
        }
        return arrayList;
    }
}

