/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.imports;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.imports.ImportReference;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ImportStatement {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker impMarker = builder.mark();
        Modifiers.parse(builder, parser);
        if (!GroovyTokenTypes.kIMPORT.equals(builder.getTokenType())) {
            impMarker.rollbackTo();
            return false;
        }
        ImportStatement.parseAfterModifiers(builder);
        impMarker.done((IElementType)GroovyElementTypes.IMPORT_STATEMENT);
        return true;
    }

    public static void parseAfterModifiers(PsiBuilder builder) {
        ParserUtils.getToken(builder, GroovyTokenTypes.kIMPORT, GroovyBundle.message("import.keyword.expected", new Object[0]));
        ParserUtils.getToken(builder, GroovyTokenTypes.kSTATIC);
        if (!ImportReference.parse(builder)) {
            builder.error(GroovyBundle.message("import.identifier.expected", new Object[0]));
        }
    }
}

