/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.gpp.GppClosureParameterTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;

public class ClosureAsAnonymousParameterEnhancer
extends AbstractClosureParameterEnhancer {
    @Override
    @Nullable
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        ArrayList expectedTypes;
        if (closure.getParent() instanceof GrSafeCastExpression) {
            GrSafeCastExpression safeCastExpression = (GrSafeCastExpression)closure.getParent();
            GrTypeElement typeElement = safeCastExpression.getCastTypeElement();
            if (typeElement != null) {
                PsiType castType = typeElement.getType();
                expectedTypes = ContainerUtil.newArrayList(GroovyExpectedTypesProvider.getDefaultExpectedTypes(safeCastExpression));
                Iterator iterator = expectedTypes.iterator();
                while (iterator.hasNext()) {
                    if (TypesUtil.isAssignable((PsiType)iterator.next(), castType, closure)) continue;
                    iterator.remove();
                }
                if (expectedTypes.isEmpty()) {
                    expectedTypes.add(castType);
                }
            } else {
                expectedTypes = GroovyExpectedTypesProvider.getDefaultExpectedTypes(closure);
            }
        } else {
            expectedTypes = GroovyExpectedTypesProvider.getDefaultExpectedTypes(closure);
        }
        for (PsiType constraint : expectedTypes) {
            PsiType suggestion = GppClosureParameterTypeProvider.getSingleMethodParameterType(constraint, index, closure);
            if (suggestion == null) continue;
            if (GroovyConfigUtils.getInstance().isVersionAtLeast(closure, "2.3") && suggestion instanceof PsiWildcardType && ((PsiWildcardType)suggestion).isSuper()) {
                return ((PsiWildcardType)suggestion).getBound();
            }
            return TypesUtil.substituteAndNormalizeType(suggestion, PsiSubstitutor.EMPTY, null, closure);
        }
        return null;
    }
}

