/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StubClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StubGenerator;

public class GroovyToJavaGenerator {
    private static final Map<String, String> typesToInitialValues = new HashMap<String, String>();
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator");
    private final Set<VirtualFile> myAllToCompile;
    private final Project myProject;

    public GroovyToJavaGenerator(Project project, Set<VirtualFile> allToCompile) {
        this.myProject = project;
        this.myAllToCompile = allToCompile;
    }

    public Map<String, CharSequence> generateStubs(GroovyFile file) {
        THashSet classNames = new THashSet();
        for (GrTypeDefinition typeDefinition : file.getTypeDefinitions()) {
            classNames.add(typeDefinition.getName());
        }
        LinkedHashMap<String, CharSequence> output = new LinkedHashMap<String, CharSequence>();
        if (file.isScript()) {
            PsiClass scriptClass;
            VirtualFile virtualFile = file.getVirtualFile();
            assert (virtualFile != null);
            String fileDefinitionName = virtualFile.getNameWithoutExtension();
            if (!classNames.contains(StringUtil.capitalize((String)fileDefinitionName)) && !classNames.contains(StringUtil.decapitalize((String)fileDefinitionName)) && (scriptClass = file.getScriptClass()) != null) {
                this.generateClassStub(scriptClass, output);
            }
        }
        for (GrTypeDefinition typeDefinition : file.getTypeDefinitions()) {
            this.generateClassStub(typeDefinition, output);
        }
        return output;
    }

    private void generateClassStub(PsiClass clazz, Map<String, CharSequence> output) {
        CharSequence text = this.generateClass(clazz);
        String filename = GroovyToJavaGenerator.getFileNameForClass(clazz);
        output.put(filename, text);
    }

    private static String getFileNameForClass(PsiClass clazz) {
        PsiFile containingFile = clazz.getContainingFile();
        GrPackageDefinition packageDefinition = ((GroovyFile)containingFile).getPackageDefinition();
        return GroovyToJavaGenerator.getPackageDirectory(packageDefinition) + clazz.getName() + ".java";
    }

    private static String getPackageDirectory(@Nullable GrPackageDefinition packageDefinition) {
        if (packageDefinition == null) {
            return "";
        }
        String prefix = packageDefinition.getPackageName();
        if (prefix == null) {
            return "";
        }
        return prefix.replace('.', '/') + '/';
    }

    public CharSequence generateClass(@NotNull PsiClass typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/refactoring/convertToJava/GroovyToJavaGenerator", "generateClass"));
        }
        try {
            StringBuilder text = new StringBuilder();
            StubClassNameProvider classNameProvider = new StubClassNameProvider(this.myAllToCompile);
            StubGenerator classItemGenerator = new StubGenerator(classNameProvider);
            new ClassGenerator(classNameProvider, classItemGenerator).writeTypeDefinition(text, typeDefinition, true, true);
            return text;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return "";
        }
    }

    public static String getDefaultValueText(String typeCanonicalText) {
        String result = typesToInitialValues.get(typeCanonicalText);
        if (result == null) {
            return "null";
        }
        return result;
    }

    public static String generateMethodStub(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/refactoring/convertToJava/GroovyToJavaGenerator", "generateMethodStub"));
        }
        if (!(method instanceof GroovyPsiElement)) {
            return method.getText();
        }
        StubGenerator generator = new StubGenerator(new StubClassNameProvider(Collections.<VirtualFile>emptySet()));
        StringBuilder buffer = new StringBuilder();
        if (method.isConstructor()) {
            generator.writeConstructor(buffer, method, false);
        } else {
            generator.writeMethod(buffer, method);
        }
        return buffer.toString();
    }

    public static StringBuilder generateStubs(PsiFile psiFile) {
        StringBuilder builder = new StringBuilder();
        Set<VirtualFile> files = Collections.singleton(psiFile.getViewProvider().getVirtualFile());
        Map<String, CharSequence> map = new GroovyToJavaGenerator(psiFile.getProject(), files).generateStubs((GroovyFile)psiFile);
        for (CharSequence stubText : map.values()) {
            builder.append(stubText);
            builder.append("\n");
            builder.append("---");
            builder.append("\n");
        }
        return builder;
    }

    static {
        typesToInitialValues.put("boolean", "false");
        typesToInitialValues.put("int", "0");
        typesToInitialValues.put("short", "0");
        typesToInitialValues.put("long", "0L");
        typesToInitialValues.put("byte", "0");
        typesToInitialValues.put("char", "'c'");
        typesToInitialValues.put("double", "0D");
        typesToInitialValues.put("float", "0F");
        typesToInitialValues.put("void", "");
    }
}

