/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.testDiscovery;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.testDiscovery.JUnitTestDiscoveryConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JUnitTestDiscoveryConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new JUnitTestDiscoveryConfiguration("", project, (ConfigurationFactory)this);
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfigurationType$1", "onNewConfigurationCreated"));
            }
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public String getDisplayName() {
        return "JUnit Test Discovery";
    }

    public String getConfigurationTypeDescription() {
        return "Runs junit tests which passed changed code";
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Junit;
    }

    @NotNull
    public String getId() {
        if ("JUnitTestDiscovery" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfigurationType", "getId"));
        }
        return "JUnitTestDiscovery";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }
}

