/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.actions;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TrackRunningTestUtil;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pass;
import com.intellij.util.config.AbstractProperty;
import javax.swing.JTree;

class RunningTestTracker
extends JUnitAdapter
implements TestFrameworkPropertyListener<Boolean> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.actions.TrackRunningTestAction");
    private final JUnitRunningModel myModel;
    private TrackingPolicy myTrackingPolicy;
    private TestProxy myLastRan = null;
    private TestProxy myLastSelected = null;
    private static final TrackingPolicy DONT_TRACK = new TrackingPolicy(){

        @Override
        protected void applyTo(TestProxy test) {
        }

        @Override
        protected void apply() {
        }
    };
    private final TrackingPolicy TRACK_RUNNING = new TrackingPolicy(){

        @Override
        protected void applyTo(TestProxy test) {
            LOG.assertTrue(RunningTestTracker.this.myModel != null);
            this.selectLastTest();
            if (!test.isLeaf() && test.getState().isPassed()) {
                RunningTestTracker.this.myModel.collapse(test);
            }
        }

        @Override
        protected void apply() {
            LOG.assertTrue(RunningTestTracker.this.myModel != null);
            this.selectLastTest();
        }

        private void selectLastTest() {
            if (RunningTestTracker.this.myLastRan != null && RunningTestTracker.isRunningState(RunningTestTracker.this.myLastRan)) {
                if (RunningTestTracker.this.myLastSelected == null) {
                    RunningTestTracker.this.myModel.selectTest(RunningTestTracker.this.myLastRan);
                } else {
                    RunningTestTracker.this.myModel.expandTest(RunningTestTracker.this.myLastRan);
                }
            }
        }
    };

    private RunningTestTracker(JUnitRunningModel model) {
        this.myModel = model;
        JTree tree = this.myModel.getTree();
        TrackRunningTestUtil.installStopListeners((JTree)tree, (Disposable)this.myModel, (Pass)new Pass<AbstractTestProxy>(){

            public void pass(AbstractTestProxy testProxy) {
                RunningTestTracker.this.myLastSelected = (TestProxy)testProxy;
            }
        });
        this.choosePolicy();
    }

    public void onChanged(Boolean value) {
        this.choosePolicy();
        this.myTrackingPolicy.apply();
    }

    @Override
    public void onTestChanged(TestEvent event) {
        if (event instanceof StateChangedEvent) {
            TestProxy proxy = event.getSource();
            boolean isRunning = RunningTestTracker.isRunningState(proxy);
            if (isRunning) {
                if (proxy.isLeaf()) {
                    this.myLastRan = proxy;
                }
                if (this.myLastSelected == proxy) {
                    this.myLastSelected = null;
                }
            } else if (proxy == this.myLastRan) {
                this.myLastRan = null;
            }
            this.myTrackingPolicy.applyTo(proxy);
        }
    }

    public static void install(JUnitRunningModel model) {
        RunningTestTracker testTracker = new RunningTestTracker(model);
        model.addListener(testTracker);
        TestFrameworkActions.addPropertyListener((AbstractProperty)JUnitConsoleProperties.TRACK_RUNNING_TEST, (TestFrameworkPropertyListener)testTracker, (TestFrameworkRunningModel)model, (boolean)false);
    }

    private static boolean isRunningState(TestProxy test) {
        return test.getState().getMagnitude() == 3;
    }

    private void choosePolicy() {
        boolean shouldTrack = JUnitConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myModel.getProperties());
        this.myTrackingPolicy = shouldTrack ? this.TRACK_RUNNING : DONT_TRACK;
    }

    private static abstract class TrackingPolicy {
        private TrackingPolicy() {
        }

        protected abstract void applyTo(TestProxy var1);

        protected abstract void apply();
    }
}

