/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.SpecialNode;
import com.intellij.execution.junit2.ui.model.TestTreeStructure;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class TestTreeBuilder
extends AbstractTestTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.model.TestTreeBuilder");
    private JUnitRunningModel myModel;
    private final JUnitAdapter myListener = new JUnitAdapter(){
        private final Collection<TestProxy> myNodesToUpdate = new HashSet<TestProxy>();

        @Override
        public void onEventsDispatched(List<TestEvent> events) {
            for (TestEvent event : events) {
                TestProxy testSubtree = (TestProxy)event.getTestSubtree();
                if (testSubtree == null) continue;
                this.myNodesToUpdate.add(testSubtree);
            }
            this.updateTree();
        }

        @Override
        public void doDispose() {
            TestTreeBuilder.this.myModel = null;
            this.myNodesToUpdate.clear();
        }

        private void updateTree() {
            TestProxy test;
            TestProxy parentToUpdate = null;
            Iterator<TestProxy> iterator = this.myNodesToUpdate.iterator();
            while (iterator.hasNext() && (parentToUpdate = (test = iterator.next()).getCommonAncestor(parentToUpdate)).getParent() != null) {
            }
            TestTreeBuilder.this.getUi().queueUpdate(parentToUpdate);
            this.myNodesToUpdate.clear();
        }
    };

    public TestTreeBuilder(TestTreeView tree, JUnitRunningModel model, JUnitConsoleProperties properties) {
        this((JTree)tree, new TestTreeStructure(model.getRoot(), properties), model);
    }

    private TestTreeBuilder(JTree tree, TestTreeStructure treeStructure, JUnitRunningModel model) {
        treeStructure.setSpecialNode(new SpecialNode(this, model));
        this.myModel = model;
        this.myModel.addListener(this.myListener);
        this.init(tree, new DefaultTreeModel(new DefaultMutableTreeNode((Object)treeStructure.createDescriptor((Object)model.getRoot(), null))), (AbstractTreeStructure)treeStructure, (Comparator)IndexComparator.INSTANCE, true);
        this.initRootNode();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getElement() == this.myModel.getRoot();
    }

    @Nullable
    public DefaultMutableTreeNode ensureTestVisible(TestProxy test) {
        AbstractTestProxy[] parents;
        DefaultMutableTreeNode node = this.getNodeForElement((Object)test);
        if (node != null) {
            if (node.getParent() != null) {
                this.expandNodeChildren((DefaultMutableTreeNode)node.getParent());
                node = this.getNodeForElement((Object)test);
            }
            return node;
        }
        for (AbstractTestProxy parent : parents = test.getPathFromRoot()) {
            this.buildNodeForElement(parent);
            node = this.getNodeForElement(parent);
            if (node == null) continue;
            this.expandNodeChildren(node);
        }
        return node;
    }
}

