/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class CompositeGenerator
extends Generator {
    private final List<Pair<Generator, Integer>> myGenerators = new ArrayList<Pair<Generator, Integer>>();
    private boolean hasLeadingNewline = true;

    public CompositeGenerator() {
    }

    public CompositeGenerator(Generator generator1, Generator generator2, int emptyLinesCount) {
        this.add(generator1);
        this.add(generator2, emptyLinesCount);
    }

    public void setHasLeadingNewline(boolean value) {
        this.hasLeadingNewline = value;
    }

    public final void add(Generator generator) {
        this.add(generator, 0);
    }

    public final void add(Generator generator, int emptyLinesCount) {
        this.myGenerators.add((Pair<Generator, Integer>)Pair.create((Object)generator, (Object)new Integer(emptyLinesCount)));
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        boolean first = true;
        for (Pair<Generator, Integer> pair : this.myGenerators) {
            if (first) {
                if (this.hasLeadingNewline) {
                    CompositeGenerator.crlf(out);
                }
                first = false;
            } else {
                CompositeGenerator.crlf(out);
            }
            int emptyLinesCount = (Integer)pair.getSecond();
            for (int idx = 0; idx < emptyLinesCount; ++idx) {
                CompositeGenerator.crlf(out);
            }
            ((Generator)pair.getFirst()).generate(out);
        }
    }

    public final int getGeneratorCount() {
        return this.myGenerators.size();
    }
}

