/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloadInfo {
    @Nullable
    private final RemoteRepositoryInfo myRemoteRepository;
    private final String myRelativeDownloadUrl;
    private final String myFileNamePrefix;
    private final String myFileNameSuffix;
    @Nullable
    private final String myPresentableUrl;

    public LibraryDownloadInfo(@NotNull RemoteRepositoryInfo remoteRepository, @NotNull @NonNls String relativeDownloadUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (remoteRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepository", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (relativeDownloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeDownloadUrl", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamePrefix", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameSuffix", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        this.myRemoteRepository = remoteRepository;
        this.myRelativeDownloadUrl = relativeDownloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = null;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamePrefix", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameSuffix", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        this.myRemoteRepository = null;
        this.myRelativeDownloadUrl = downloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = presentableUrl != null ? presentableUrl : downloadUrl;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamePrefix", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        this(downloadUrl, presentableUrl, fileNamePrefix, ".jar");
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamePrefix", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "<init>"));
        }
        this(downloadUrl, null, fileNamePrefix);
    }

    @NotNull
    public String getDownloadUrl() {
        String string = this.myRemoteRepository != null ? this.getDownloadUrl(this.myRemoteRepository.getDefaultMirror()) : this.myRelativeDownloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getDownloadUrl"));
        }
        return string;
    }

    @NotNull
    public String getDownloadUrl(String mirror) {
        String string = mirror + this.myRelativeDownloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getDownloadUrl"));
        }
        return string;
    }

    @Nullable
    public RemoteRepositoryInfo getRemoteRepository() {
        return this.myRemoteRepository;
    }

    @NotNull
    public String getFileNamePrefix() {
        String string = this.myFileNamePrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getFileNamePrefix"));
        }
        return string;
    }

    @NotNull
    public String getFileNameSuffix() {
        String string = this.myFileNameSuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getFileNameSuffix"));
        }
        return string;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileNamePrefix + this.myFileNameSuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getFileName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : (this.myRemoteRepository != null ? this.myRemoteRepository.getDefaultMirror() : this.myRelativeDownloadUrl);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getPresentableUrl"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl(String mirror) {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : mirror;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/ui/libraries/LibraryDownloadInfo", "getPresentableUrl"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryDownloadInfo that = (LibraryDownloadInfo)o;
        if (!this.myFileNamePrefix.equals(that.myFileNamePrefix)) {
            return false;
        }
        if (!this.myFileNameSuffix.equals(that.myFileNameSuffix)) {
            return false;
        }
        if (!Comparing.equal((String)this.myPresentableUrl, (String)that.myPresentableUrl)) {
            return false;
        }
        if (!this.myRelativeDownloadUrl.equals(that.myRelativeDownloadUrl)) {
            return false;
        }
        return Comparing.equal((Object)this.myRemoteRepository, (Object)that.myRemoteRepository);
    }

    public int hashCode() {
        int result = this.myRemoteRepository != null ? this.myRemoteRepository.hashCode() : 0;
        result = 31 * result + (this.myRelativeDownloadUrl != null ? this.myRelativeDownloadUrl.hashCode() : 0);
        result = 31 * result + (this.myFileNamePrefix != null ? this.myFileNamePrefix.hashCode() : 0);
        result = 31 * result + (this.myFileNameSuffix != null ? this.myFileNameSuffix.hashCode() : 0);
        result = 31 * result + (this.myPresentableUrl != null ? this.myPresentableUrl.hashCode() : 0);
        return result;
    }
}

