/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CreateElementActionBase
extends AnAction {
    protected CreateElementActionBase() {
    }

    protected CreateElementActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected abstract PsiElement[] invokeDialog(Project var1, PsiDirectory var2);

    @NotNull
    protected abstract PsiElement[] create(String var1, PsiDirectory var2) throws Exception;

    protected abstract String getErrorTitle();

    protected abstract String getCommandName();

    protected abstract String getActionName(PsiDirectory var1, String var2);

    @Override
    public final void actionPerformed(AnActionEvent e) {
        PsiElement[] createdElements;
        IdeView view = e.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            return;
        }
        Project project = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        for (PsiElement createdElement : createdElements = this.invokeDialog(project, dir)) {
            view.selectElement(createdElement);
        }
    }

    @Override
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        if (DumbService.getInstance(project).isDumb() && !this.isDumbAware()) {
            return false;
        }
        IdeView view = LangDataKeys.IDE_VIEW.getData(dataContext);
        return view != null && view.getDirectories().length != 0;
    }

    public static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        if (message.startsWith("java.io.IOException:")) {
            message = message.substring("java.io.IOException:".length());
        }
        return message;
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            super(project, CreateElementActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @Override
        public boolean checkInput(String inputString) {
            return true;
        }

        @Override
        public PsiElement[] create(String newName) throws Exception {
            return CreateElementActionBase.this.create(newName, this.myDirectory);
        }

        @Override
        public String getActionName(String newName) {
            return CreateElementActionBase.this.getActionName(this.myDirectory, newName);
        }

        @Override
        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

