/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;

public class DiffContentUtil {
    public static FileType getContentType(VirtualFile file) {
        if (file == null) {
            return null;
        }
        return file.getFileType();
    }

    public static boolean isTextFile(VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory() && DiffContentUtil.isTextType(file.getFileType());
    }

    public static boolean isTextType(FileType fileType) {
        return fileType != null && !fileType.isBinary();
    }

    public static String getTitle(VirtualFile virtualFile) {
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return virtualFile.getPresentableUrl();
        }
        return virtualFile.getName() + " (" + parent.getPresentableUrl() + ")";
    }
}

