/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskData
extends AbstractExternalEntityData
implements ExternalConfigPathAware,
Comparable<TaskData> {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @Nullable
    private final String myDescription;
    @NotNull
    private final String myLinkedExternalProjectPath;
    @Nullable
    private String myGroup;
    private boolean myInherited;

    public TaskData(@NotNull ProjectSystemId owner, @NotNull String name, @NotNull String path2, @Nullable String description) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/task/TaskData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/task/TaskData", "<init>"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/model/task/TaskData", "<init>"));
        }
        super(owner);
        this.myName = name;
        this.myLinkedExternalProjectPath = path2;
        this.myDescription = description;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/TaskData", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myLinkedExternalProjectPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/task/TaskData", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(@Nullable String group) {
        this.myGroup = group;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    public void setInherited(boolean inherited) {
        this.myInherited = inherited;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result = 31 * result + this.myLinkedExternalProjectPath.hashCode();
        result = 31 * result + (this.myInherited ? 1 : 0);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskData data = (TaskData)o;
        if (this.myInherited != data.myInherited) {
            return false;
        }
        if (!this.myName.equals(data.myName)) {
            return false;
        }
        if (this.myGroup != null ? !this.myGroup.equals(data.myGroup) : data.myGroup != null) {
            return false;
        }
        if (!this.myLinkedExternalProjectPath.equals(data.myLinkedExternalProjectPath)) {
            return false;
        }
        return !(this.myDescription != null ? !this.myDescription.equals(data.myDescription) : data.myDescription != null);
    }

    @Override
    public int compareTo(@NotNull TaskData that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/externalSystem/model/task/TaskData", "compareTo"));
        }
        return this.myName.compareTo(that.getName());
    }

    public String toString() {
        return this.myName;
    }
}

