/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JavaResourceRootProperties
extends JpsElementBase<JavaResourceRootProperties> {
    private String myRelativeOutputPath;
    private boolean myForGeneratedSources;

    public JavaResourceRootProperties(@NotNull String relativeOutputPath, boolean forGeneratedSources) {
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "org/jetbrains/jps/model/java/JavaResourceRootProperties", "<init>"));
        }
        this.myRelativeOutputPath = "";
        this.myRelativeOutputPath = relativeOutputPath;
        this.myForGeneratedSources = forGeneratedSources;
    }

    @NotNull
    public String getRelativeOutputPath() {
        String string = this.myRelativeOutputPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JavaResourceRootProperties", "getRelativeOutputPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public JavaResourceRootProperties createCopy() {
        JavaResourceRootProperties javaResourceRootProperties = new JavaResourceRootProperties(this.myRelativeOutputPath, this.myForGeneratedSources);
        if (javaResourceRootProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JavaResourceRootProperties", "createCopy"));
        }
        return javaResourceRootProperties;
    }

    public boolean isForGeneratedSources() {
        return this.myForGeneratedSources;
    }

    public void setRelativeOutputPath(@NotNull String relativeOutputPath) {
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "org/jetbrains/jps/model/java/JavaResourceRootProperties", "setRelativeOutputPath"));
        }
        if (!Comparing.equal((String)this.myRelativeOutputPath, (String)relativeOutputPath)) {
            this.myRelativeOutputPath = relativeOutputPath;
            this.fireElementChanged();
        }
    }

    public void setForGeneratedSources(boolean forGeneratedSources) {
        if (this.myForGeneratedSources != forGeneratedSources) {
            this.myForGeneratedSources = forGeneratedSources;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(@NotNull JavaResourceRootProperties modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/model/java/JavaResourceRootProperties", "applyChanges"));
        }
        this.setRelativeOutputPath(modified.myRelativeOutputPath);
        this.setForGeneratedSources(modified.myForGeneratedSources);
    }
}

