/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.doc.TaskPsiElement;

public class ShowTaskDescription
extends BaseTaskAction {
    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        if (event.getPresentation().isEnabled()) {
            Presentation presentation = event.getPresentation();
            LocalTask activeTask = ShowTaskDescription.getActiveTask(event);
            presentation.setEnabled(activeTask != null && activeTask.isIssue() && activeTask.getDescription() != null);
            if (activeTask == null || !activeTask.isIssue()) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText("Show '" + activeTask.getPresentableName() + "' _Description");
            }
        }
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = ShowTaskDescription.getProject(e);
        assert (project != null);
        final LocalTask task = ShowTaskDescription.getActiveTask(e);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickjavadoc.ctrln");
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                DocumentationManager.getInstance((Project)project).showJavaDocInfo((PsiElement)new TaskPsiElement(PsiManager.getInstance((Project)project), (Task)task), null);
            }
        }, this.getCommandName(), null);
    }

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }
}

