/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CaptionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public interface PopupBorder
extends Border {
    public void setActive(boolean var1);

    public static class BaseBorder
    implements PopupBorder {
        private final boolean myVisible;
        private final Color myActiveColor;
        private final Color myPassiveColor;
        private boolean myActive;

        protected BaseBorder() {
            this(false, null, null);
        }

        protected BaseBorder(boolean visible, Color activeColor, Color passiveColor) {
            this.myVisible = visible;
            this.myActiveColor = activeColor;
            this.myPassiveColor = passiveColor;
        }

        @Override
        public void setActive(boolean active) {
            this.myActive = active;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.myVisible) {
                return;
            }
            Color color = this.myActive ? this.myActiveColor : this.myPassiveColor;
            g.setColor(color);
            g.drawRect(x, y, width - 1, height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myVisible ? new Insets(1, 1, 1, 1) : new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class Factory {
        private Factory() {
        }

        @NotNull
        public static PopupBorder createEmpty() {
            BaseBorder baseBorder = new BaseBorder();
            if (baseBorder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/PopupBorder$Factory", "createEmpty"));
            }
            return baseBorder;
        }

        @NotNull
        public static PopupBorder create(boolean active, boolean windowWithShadow) {
            PopupBorder border = SystemInfo.isMac && windowWithShadow ? Factory.createEmpty() : new BaseBorder(true, CaptionPanel.getBorderColor(true), CaptionPanel.getBorderColor(false));
            border.setActive(active);
            PopupBorder popupBorder = border;
            if (popupBorder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/PopupBorder$Factory", "create"));
            }
            return popupBorder;
        }
    }
}

