/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgType;
import com.google.common.base.Objects;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public final class SystemImageDescription {
    private IAndroidTarget myTarget;
    private ISystemImage mySystemImage;
    private IPkgDesc myRemotePackage;

    public SystemImageDescription(IAndroidTarget target, ISystemImage systemImage) {
        this.myTarget = target;
        this.mySystemImage = systemImage;
    }

    public SystemImageDescription(IPkgDesc remotePackage, IAndroidTarget target) {
        this.myRemotePackage = remotePackage;
        this.myTarget = target;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myTarget, this.mySystemImage, this.myRemotePackage});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemImageDescription)) {
            return false;
        }
        SystemImageDescription other = (SystemImageDescription)obj;
        return Objects.equal((Object)this.myTarget, (Object)other.myTarget) && Objects.equal((Object)this.mySystemImage, (Object)other.mySystemImage) && Objects.equal((Object)this.myRemotePackage, (Object)other.myRemotePackage);
    }

    @Nullable
    public AndroidVersion getVersion() {
        if (this.myTarget != null) {
            return this.myTarget.getVersion();
        }
        if (this.myRemotePackage != null) {
            return this.myRemotePackage.getAndroidVersion();
        }
        return null;
    }

    public IPkgDesc getRemotePackage() {
        return this.myRemotePackage;
    }

    public boolean isRemote() {
        return this.myRemotePackage != null;
    }

    @Nullable
    public String getAbiType() {
        if (this.mySystemImage != null) {
            return this.mySystemImage.getAbiType();
        }
        if (this.myRemotePackage.getType() == PkgType.PKG_SYS_IMAGE || this.myRemotePackage.getType() == PkgType.PKG_ADDON_SYS_IMAGE) {
            return this.myRemotePackage.getPath();
        }
        return "";
    }

    @Nullable
    public IdDisplay getTag() {
        if (this.mySystemImage != null) {
            return this.mySystemImage.getTag();
        }
        return this.myRemotePackage.getTag();
    }

    public String getName() {
        if (this.myTarget != null) {
            return this.myTarget.getFullName();
        }
        if (this.myRemotePackage != null) {
            return String.format("%s not installed", this.myRemotePackage.getAndroidVersion());
        }
        return "Unknown platform";
    }

    public String getVendor() {
        IdDisplay vendor;
        if (this.myTarget != null) {
            return this.myTarget.getVendor();
        }
        if (this.mySystemImage != null && this.mySystemImage.getAddonVendor() != null) {
            return this.mySystemImage.getAddonVendor().getDisplay();
        }
        if (this.myRemotePackage != null && (vendor = this.myRemotePackage.getVendor()) != null) {
            return vendor.getDisplay();
        }
        return "";
    }

    public String getVersionName() {
        if (this.myTarget != null) {
            return this.myTarget.getVersionName();
        }
        return "";
    }

    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public File[] getSkins() {
        if (this.myTarget != null) {
            return this.myTarget.getSkins();
        }
        return new File[0];
    }
}

