/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceViewPanel;
import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.ContextController;
import com.android.tools.idea.editors.gfxtrace.controllers.DocumentationController;
import com.android.tools.idea.editors.gfxtrace.controllers.FrameBufferController;
import com.android.tools.idea.editors.gfxtrace.controllers.GfxController;
import com.android.tools.idea.editors.gfxtrace.controllers.ScrubberController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.AtomNode;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.EnumInfoCache;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.HierarchyNode;
import com.android.tools.idea.editors.gfxtrace.renderers.ScrubberCellRenderer;
import com.android.tools.idea.editors.gfxtrace.rpc.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.rpc.AtomStream;
import com.android.tools.idea.editors.gfxtrace.rpc.Capture;
import com.android.tools.idea.editors.gfxtrace.rpc.CaptureId;
import com.android.tools.idea.editors.gfxtrace.rpc.Client;
import com.android.tools.idea.editors.gfxtrace.rpc.ClientImpl;
import com.android.tools.idea.editors.gfxtrace.rpc.Device;
import com.android.tools.idea.editors.gfxtrace.rpc.DeviceId;
import com.android.tools.idea.editors.gfxtrace.rpc.Hierarchy;
import com.android.tools.idea.editors.gfxtrace.rpc.Schema;
import com.android.tools.idea.editors.gfxtrace.schema.Atom;
import com.android.tools.idea.editors.gfxtrace.schema.AtomReader;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceEditor
extends UserDataHolderBase
implements FileEditor,
ScrubberCellRenderer.DimensionChangeListener {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    @NotNull
    private static final String SERVER_HOST = "localhost";
    @NotNull
    private static final String SERVER_EXECUTABLE_NAME = "gapis";
    @NotNull
    private static final String SERVER_RELATIVE_PATH = "bin";
    private static final int SERVER_PORT = 6700;
    private static final int SERVER_LAUNCH_TIMEOUT_MS = 2000;
    private static final int SERVER_LAUNCH_SLEEP_INCREMENT_MS = 10;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GfxTraceViewPanel myView;
    @NotNull
    private final ListeningExecutorService myService;
    private Process myServerProcess;
    private Socket myServerSocket;
    @NotNull
    private Client myClient;
    private Schema mySchema;
    private EnumInfoCache myEnumInfoCache;
    private AtomStream myAtomStream;
    private AtomReader myAtomReader;
    @NotNull
    private List<GfxController> myControllers;
    private ContextController myContextController;
    private AtomController myAtomController;
    private ScrubberController myScrubberController;
    private FrameBufferController myFrameBufferController;
    private StateController myStateController;
    private DocumentationController myDocumentationController;
    private volatile int myCaptureChangeId;
    private boolean myIsConnectedToServer;

    public GfxTraceEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        this.myService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        this.myControllers = new ArrayList<GfxController>();
        this.myProject = project;
        this.myView = new GfxTraceViewPanel();
        this.myView.setupViewHierarchy(this.myProject);
        try {
            if (this.connectToServer()) {
                this.myClient = new ClientImpl(Executors.newCachedThreadPool(), this.myServerSocket.getInputStream(), this.myServerSocket.getOutputStream(), 1024);
                this.myIsConnectedToServer = true;
                this.myContextController = new ContextController(this, this.myView.getDeviceList(), this.myView.getCapturesList(), this.myView.getGfxContextList());
                this.myAtomController = new AtomController(project, this.myView.getAtomScrollPane());
                this.myScrubberController = new ScrubberController(this, this.myView.getScrubberScrollPane(), this.myView.getScrubberList());
                this.myFrameBufferController = new FrameBufferController(this, this.myView.getBufferTabs(), this.myView.getColorScrollPane(), this.myView.getWireframeScrollPane(), this.myView.getDepthScrollPane());
                this.myStateController = new StateController(this, this.myView.getStateScrollPane());
                this.myControllers.add(this.myAtomController);
                this.myControllers.add(this.myScrubberController);
                this.myControllers.add(this.myStateController);
                this.myControllers.add(this.myFrameBufferController);
                this.myContextController.initialize();
                this.myDocumentationController = new DocumentationController(this.myView.getDocsPane());
                this.establishInterViewControls();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getProject"));
        }
        return project;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myView.getRootComponent();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("GfxTraceView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getName"));
        }
        return "GfxTraceView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public Client getClient() {
        Client client = this.myClient;
        if (client == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getClient"));
        }
        return client;
    }

    @Nullable
    public CaptureId getCaptureId() {
        if (this.myContextController.getCurrentCapture() != null) {
            return this.myContextController.getCurrentCaptureId();
        }
        return null;
    }

    @Nullable
    public DeviceId getDeviceId() {
        if (this.myContextController.getCurrentDevice() != null) {
            return this.myContextController.getCurrentDeviceId();
        }
        return null;
    }

    @NotNull
    public ListeningExecutorService getService() {
        ListeningExecutorService listeningExecutorService = this.myService;
        if (listeningExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getService"));
        }
        return listeningExecutorService;
    }

    @Nullable
    public Integer getContext() {
        return this.myContextController.getCurrentContext();
    }

    private void clearCaptureState() {
        this.mySchema = null;
        this.myAtomReader = null;
    }

    private void clear() {
        for (GfxController controller : this.myControllers) {
            controller.clear();
        }
    }

    public void dispose() {
        if (this.myServerSocket != null) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myServerProcess != null) {
            this.myServerProcess.destroy();
        }
        this.myService.shutdown();
    }

    public void notifyDeviceChanged(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "notifyDeviceChanged"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (GfxController controller : this.myControllers) {
            controller.clearCache();
        }
    }

    private void sleepThread(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean connectToServer() {
        this.myServerSocket = null;
        try {
            this.myServerSocket = new Socket(SERVER_HOST, 6700);
        }
        catch (IOException e) {
            this.myServerSocket = null;
        }
        if (this.myServerSocket == null) {
            try {
                File baseDirectory = new File(PathUtil.getJarPathForClass(this.getClass()));
                if (baseDirectory.isFile()) {
                    baseDirectory = baseDirectory.getParentFile();
                }
                if (baseDirectory.isDirectory()) {
                    File serverDirectory = new File(baseDirectory, SERVER_RELATIVE_PATH);
                    File serverExecutable = new File(serverDirectory, SERVER_EXECUTABLE_NAME);
                    ProcessBuilder pb = new ProcessBuilder(serverExecutable.getAbsolutePath());
                    Map<String, String> env = pb.environment();
                    String path = env.get("PATH");
                    path = serverDirectory.getAbsolutePath() + File.pathSeparator + path;
                    env.put("PATH", path);
                    pb.directory(baseDirectory);
                    this.myServerProcess = pb.start();
                } else {
                    LOG.error("baseDirectory is not a directory: \"" + baseDirectory.getAbsolutePath() + "\"");
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            if (this.myServerProcess != null) {
                for (int waitTime = 0; this.myServerSocket == null && waitTime < 2000; waitTime += 10) {
                    try {
                        this.myServerSocket = new Socket(SERVER_HOST, 6700);
                        continue;
                    }
                    catch (IOException e1) {
                        this.myServerSocket = null;
                        this.sleepThread(10);
                    }
                }
            }
        }
        return this.myServerSocket != null;
    }

    public void notifyCaptureChanged(final @NotNull Capture capture) {
        if (capture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capture", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "notifyCaptureChanged"));
        }
        ++this.myCaptureChangeId;
        final int closedCaptureChangeId = this.myCaptureChangeId;
        this.clear();
        this.clearCaptureState();
        ListenableFuture captureChange = this.myService.submit((Callable)new Callable<GfxController.CaptureChangeState>(){

            @Override
            public GfxController.CaptureChangeState call() throws Exception {
                AtomStream atomStream = GfxTraceEditor.this.myClient.ResolveAtomStream(capture.getAtoms()).get();
                Schema schema = GfxTraceEditor.this.myClient.ResolveSchema(atomStream.getSchema()).get();
                return new GfxController.CaptureChangeState(atomStream, schema);
            }
        });
        Futures.addCallback((ListenableFuture)captureChange, (FutureCallback)new FutureCallback<GfxController.CaptureChangeState>(){

            public void onSuccess(@Nullable GfxController.CaptureChangeState state) {
                if (state != null && GfxTraceEditor.this.myIsConnectedToServer && closedCaptureChangeId == GfxTraceEditor.this.myCaptureChangeId) {
                    GfxTraceEditor.this.myAtomStream = state.myAtomStream;
                    GfxTraceEditor.this.mySchema = state.mySchema;
                    GfxTraceEditor.this.myEnumInfoCache = new EnumInfoCache(GfxTraceEditor.this.mySchema);
                    GfxTraceEditor.this.myContextController.populateUi(capture.getContextIds());
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor$2", "onFailure"));
                }
                LOG.error(t);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    @Override
    public void notifyDimensionChanged(@NotNull Dimension newDimension) {
        if (newDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDimension", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "notifyDimensionChanged"));
        }
        this.myView.resize();
    }

    public void resolveGfxContextChange(final @NotNull AtomicBoolean shouldStop) {
        if (shouldStop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldStop", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "resolveGfxContextChange"));
        }
        final int closedCaptureChangeId = this.myCaptureChangeId;
        this.clear();
        for (GfxController controller : this.myControllers) {
            controller.startLoad();
        }
        final GfxController.GfxContextChangeState state = new GfxController.GfxContextChangeState();
        state.myCaptureChangeState.myAtomStream = this.myAtomStream;
        state.myCaptureChangeState.mySchema = this.mySchema;
        state.myEnumInfoCache = this.myEnumInfoCache;
        assert (this.myContextController.getCurrentCapture() != null);
        final CaptureId captureId = this.myContextController.getCurrentCaptureId();
        final Integer contextId = this.myContextController.getCurrentContext();
        assert (contextId != null);
        ListenableFuture contextChange = this.myService.submit((Callable)new Callable<GfxController.GfxContextChangeState>(){

            @Override
            @Nullable
            public GfxController.GfxContextChangeState call() throws Exception {
                if (shouldStop.get()) {
                    return null;
                }
                Hierarchy hierarchy = GfxTraceEditor.this.myClient.ResolveHierarchy(GfxTraceEditor.this.myClient.GetHierarchy(captureId, contextId).get()).get();
                state.myAtomReader = new AtomReader(state.myCaptureChangeState.myAtomStream, state.myCaptureChangeState.mySchema);
                state.myTreeRoot = AtomController.prepareData(hierarchy);
                state.myScrubberList = GfxTraceEditor.this.myScrubberController.prepareData(hierarchy, state.myAtomReader);
                return state;
            }
        });
        Futures.addCallback((ListenableFuture)contextChange, (FutureCallback)new FutureCallback<GfxController.GfxContextChangeState>(){

            public void onSuccess(@Nullable GfxController.GfxContextChangeState result) {
                if (result != null) {
                    GfxTraceEditor.this.myAtomReader = result.myAtomReader;
                    for (GfxController controller : GfxTraceEditor.this.myControllers) {
                        controller.commitData(result);
                    }
                    GfxTraceEditor.this.populateUi(shouldStop, closedCaptureChangeId);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor$4", "onFailure"));
                }
                LOG.error(t);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private void populateUi(@NotNull AtomicBoolean shouldStop, int initialCaptureChangeId) {
        if (shouldStop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldStop", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "populateUi"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!shouldStop.get() && initialCaptureChangeId == this.myCaptureChangeId) {
            assert (this.myContextController.getCurrentContext() != null);
            this.myScrubberController.populateUi(this.myClient);
            this.myAtomController.populateUi(this.myAtomReader);
        }
    }

    private void establishInterViewControls() {
        this.myAtomController.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                long atomId;
                DefaultMutableTreeNode node;
                Object userObject;
                if (treeSelectionEvent.isAddedPath()) {
                    Object[] pathObjects = treeSelectionEvent.getPath().getPath();
                    assert (pathObjects.length >= 2);
                    assert (pathObjects[1] instanceof DefaultMutableTreeNode);
                    userObject = ((DefaultMutableTreeNode)pathObjects[1]).getUserObject();
                    assert (userObject instanceof HierarchyNode);
                    HierarchyNode node2 = (HierarchyNode)userObject;
                    GfxTraceEditor.this.myScrubberController.selectFrame(node2.getRepresentativeAtomId());
                }
                if ((node = (DefaultMutableTreeNode)GfxTraceEditor.this.myAtomController.getTree().getLastSelectedPathComponent()) == null) {
                    GfxTraceEditor.this.myFrameBufferController.clearCache();
                    return;
                }
                userObject = node.getUserObject();
                assert (userObject instanceof HierarchyNode || userObject instanceof AtomNode);
                if (userObject instanceof HierarchyNode) {
                    HierarchyNode hierarchyNode = (HierarchyNode)userObject;
                    atomId = hierarchyNode.getRepresentativeAtomId();
                } else {
                    AtomNode atomNode = (AtomNode)userObject;
                    atomId = atomNode.getRepresentativeAtomId();
                    try {
                        GfxTraceEditor.this.myDocumentationController.setDocumentation(((GfxTraceEditor)GfxTraceEditor.this).myAtomReader.read((long)atomId).info.getDocumentationUrl());
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        return;
                    }
                }
                GfxTraceEditor.this.myFrameBufferController.setImageForId(GfxTraceEditor.this.findPreviousDrawCall(atomId));
                GfxTraceEditor.this.myStateController.updateTreeModelFromAtomId(atomId);
            }
        });
        this.myView.getScrubberList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AtomGroup selection;
                if (!listSelectionEvent.getValueIsAdjusting() && (selection = GfxTraceEditor.this.myScrubberController.getFrameSelectionReference()) != null) {
                    GfxTraceEditor.this.myAtomController.selectFrame(selection);
                }
            }
        });
    }

    private long findPreviousDrawCall(long selectedId) {
        try {
            Atom atom = this.myAtomReader.read(selectedId);
            if (atom.info.getIsDrawCall()) {
                return selectedId;
            }
            if (selectedId - 1L > Integer.MAX_VALUE) {
                throw new RuntimeException("Selected Atom ID exceeds largest Atom ID supported.");
            }
            for (long i = selectedId - 1L; i >= 0L; --i) {
                atom = this.myAtomReader.read(i);
                if (atom.info.getIsDrawCall()) {
                    return i;
                }
                if (!atom.info.getIsEndOfFrame()) continue;
                return i + 1L;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return 0L;
    }
}

