/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.controllers.GfxController;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.AtomNode;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.EnumInfoCache;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.HierarchyNode;
import com.android.tools.idea.editors.gfxtrace.renderers.AtomTreeRenderer;
import com.android.tools.idea.editors.gfxtrace.rpc.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.rpc.Hierarchy;
import com.android.tools.idea.editors.gfxtrace.schema.AtomReader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class AtomController
implements GfxController {
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final SimpleTree myTree;
    @NotNull
    private final AtomTreeRenderer myAtomTreeRenderer;
    private TreeNode myAtomTreeRoot;
    private EnumInfoCache myEnumInfoCache;

    public AtomController(@NotNull Project project, @NotNull JBScrollPane scrollPane) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "<init>"));
        }
        if (scrollPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollPane", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "<init>"));
        }
        scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.myTree = new SimpleTree();
        this.myTree.setRowHeight(19);
        this.myTree.setRootVisible(false);
        this.myTree.setLineStyleAngled();
        this.myTree.getEmptyText().setText("Select a capture");
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        this.myLoadingPanel.add((Component)this.myTree);
        scrollPane.setViewportView((Component)this.myLoadingPanel);
        this.myAtomTreeRenderer = new AtomTreeRenderer();
    }

    @NotNull
    public static TreeNode prepareData(@NotNull Hierarchy hierarchy) {
        if (hierarchy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "prepareData"));
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        MutableTreeNode mutableTreeNode = AtomController.generateAtomTree(hierarchy.getRoot());
        if (mutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "prepareData"));
        }
        return mutableTreeNode;
    }

    @NotNull
    private static MutableTreeNode generateAtomTree(@NotNull AtomGroup atomGroup) {
        if (atomGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atomGroup", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "generateAtomTree"));
        }
        assert (atomGroup.getRange().getCount() > 0L);
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode();
        currentNode.setUserObject(new HierarchyNode(atomGroup));
        long lastGroupIndex = atomGroup.getRange().getFirst();
        for (AtomGroup subGroup : atomGroup.getSubGroups()) {
            long subGroupFirst = subGroup.getRange().getFirst();
            assert (subGroupFirst >= lastGroupIndex);
            if (subGroupFirst > lastGroupIndex) {
                AtomController.addLeafNodes(currentNode, subGroupFirst, subGroupFirst - lastGroupIndex);
            }
            currentNode.add(AtomController.generateAtomTree(subGroup));
            lastGroupIndex = subGroup.getRange().getFirst() + subGroup.getRange().getCount();
        }
        long nextSiblingStartIndex = atomGroup.getRange().getFirst() + atomGroup.getRange().getCount();
        if (nextSiblingStartIndex > lastGroupIndex) {
            AtomController.addLeafNodes(currentNode, lastGroupIndex, nextSiblingStartIndex - lastGroupIndex);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = currentNode;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "generateAtomTree"));
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - void declaration
     */
    private static void addLeafNodes(@NotNull DefaultMutableTreeNode parentNode, long start, long l) {
        void count;
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "addLeafNodes"));
        }
        long i = 0L;
        long index = start;
        while (i < count) {
            AtomNode atomNode = new AtomNode(index);
            parentNode.add(new DefaultMutableTreeNode(atomNode, false));
            ++i;
            ++index;
        }
    }

    @NotNull
    public SimpleTree getTree() {
        SimpleTree simpleTree = this.myTree;
        if (simpleTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "getTree"));
        }
        return simpleTree;
    }

    @Override
    public void startLoad() {
        this.myTree.getEmptyText().setText("");
        this.myLoadingPanel.startLoading();
    }

    @Override
    public void commitData(@NotNull GfxController.GfxContextChangeState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "commitData"));
        }
        this.myEnumInfoCache = state.myEnumInfoCache;
        this.myAtomTreeRoot = state.myTreeRoot;
    }

    public void populateUi(@NotNull AtomReader atomReader) {
        if (atomReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atomReader", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "populateUi"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myAtomTreeRoot != null);
        this.myAtomTreeRenderer.init(this.myEnumInfoCache, atomReader);
        this.myTree.setModel((TreeModel)new DefaultTreeModel(this.myAtomTreeRoot));
        this.myTree.setLargeModel(true);
        this.myTree.setRowHeight(19);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)this.myAtomTreeRenderer));
        if (this.myAtomTreeRoot.getChildCount() == 0) {
            this.myTree.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        }
        this.myLoadingPanel.stopLoading();
        this.myLoadingPanel.revalidate();
    }

    public void selectFrame(@NotNull AtomGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "selectFrame"));
        }
        Enumeration<? extends TreeNode> it = this.myAtomTreeRoot.children();
        while (it.hasMoreElements()) {
            TreeNode node = it.nextElement();
            assert (node instanceof DefaultMutableTreeNode);
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (!(userObject instanceof HierarchyNode) || !((HierarchyNode)userObject).isProxyFor(group)) continue;
            TreePath path = new TreePath(new Object[]{this.myAtomTreeRoot, node});
            this.select(path);
            break;
        }
    }

    @Override
    public void clear() {
        this.myTree.setModel(null);
        this.myAtomTreeRenderer.clearState();
        this.myAtomTreeRoot = null;
        this.myEnumInfoCache = null;
    }

    @Override
    public void clearCache() {
        this.myTree.clearSelection();
    }

    private void select(@NotNull TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/AtomController", "select"));
        }
        this.myTree.setSelectionPath(path);
        this.myTree.scrollPathToVisible(path);
    }
}

