/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.rpc.Binary;
import com.android.tools.idea.editors.gfxtrace.rpc.ImageFormat;
import com.android.tools.idea.editors.gfxtrace.rpc.ImageInfo;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class FetchedImage {
    @NotNull
    private final ImageInfo myImageInfo;
    @NotNull
    private final Binary myBinary;
    @NotNull
    private final DepthConversionMode myDepthConversionMode;

    public FetchedImage(@NotNull ImageInfo imageInfo, @NotNull Binary binary) {
        if (imageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInfo", "com/android/tools/idea/editors/gfxtrace/controllers/FetchedImage", "<init>"));
        }
        if (binary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "com/android/tools/idea/editors/gfxtrace/controllers/FetchedImage", "<init>"));
        }
        this.myDepthConversionMode = DepthConversionMode.GO_CLIENT;
        this.myImageInfo = imageInfo;
        this.myBinary = binary;
    }

    @NotNull
    public ImageIcon createImageIcon() {
        Dimension imageDimensions = this.getImageDimensions();
        BufferedImage image = new BufferedImage(imageDimensions.width, imageDimensions.height, 7);
        WritableRaster raster = image.getRaster();
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        this.setImageBytes(dataBuffer.getData());
        ImageIcon imageIcon = new ImageIcon(image);
        if (imageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FetchedImage", "createImageIcon"));
        }
        return imageIcon;
    }

    @NotNull
    private Dimension getImageDimensions() {
        Dimension dimension = new Dimension(this.myImageInfo.getWidth(), this.myImageInfo.getHeight());
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FetchedImage", "getImageDimensions"));
        }
        return dimension;
    }

    private void setImageBytes(@NotNull byte[] destination) {
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/editors/gfxtrace/controllers/FetchedImage", "setImageBytes"));
        }
        if (this.myImageInfo.getFormat() == ImageFormat.RGBA8) {
            Dimension dimension = this.getImageDimensions();
            int stride = dimension.width * 4;
            int length = stride * dimension.height;
            assert (destination.length >= length);
            byte[] data = this.myBinary.getData();
            for (int y = 0; y < dimension.height; ++y) {
                int yOffsetSource = stride * y;
                int yOffsetDestination = length - stride - yOffsetSource;
                for (int x = 0; x < stride; x += 4) {
                    int destinationOffset = yOffsetDestination + x;
                    int sourceOffset = yOffsetSource + x;
                    destination[destinationOffset] = -1;
                    destination[destinationOffset + 1] = data[sourceOffset + 2];
                    destination[destinationOffset + 2] = data[sourceOffset + 1];
                    destination[destinationOffset + 3] = data[sourceOffset];
                }
            }
        } else if (this.myImageInfo.getFormat() == ImageFormat.Float32) {
            Dimension dimension = this.getImageDimensions();
            int stride = dimension.width * 4;
            int length = stride * dimension.height;
            assert (destination.length >= length);
            byte[] data = this.myBinary.getData();
            byte[] floatBuffer = new byte[4];
            ByteBuffer intBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            for (int y = 0; y < dimension.height; ++y) {
                int yOffsetSource = stride * y;
                int yOffsetDestination = length - stride - yOffsetSource;
                for (int x = 0; x < stride; x += 4) {
                    byte green;
                    byte blue;
                    byte red;
                    int destinationOffset = yOffsetDestination + x;
                    int sourceOffset = yOffsetSource + x;
                    floatBuffer[0] = data[sourceOffset];
                    floatBuffer[1] = data[sourceOffset + 1];
                    floatBuffer[2] = data[sourceOffset + 2];
                    floatBuffer[3] = data[sourceOffset + 3];
                    float depth = ByteBuffer.wrap(floatBuffer).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                    assert (depth <= 1.0f);
                    switch (this.myDepthConversionMode) {
                        case GO_CLIENT: {
                            float semiLinearDepth = 0.01f / (1.0f - depth);
                            double realRed = Math.cos((double)semiLinearDepth + Math.PI * 2) * 127.0 + 128.0;
                            double realGreen = Math.cos((double)semiLinearDepth + 2.0943741924174493) * 127.0 + 128.0;
                            double realBlue = Math.cos((double)semiLinearDepth + 4.188811302015651) * 127.0 + 128.0;
                            red = (byte)realRed;
                            blue = (byte)realBlue;
                            green = (byte)realGreen;
                            break;
                        }
                        case TRIGONOMETRIC: {
                            float semiLinearDepth = 1.0f / (1.0009766f - depth) / 1024.999f;
                            double realRed = (1.0 - Math.cos((double)semiLinearDepth * Math.PI)) / 2.0;
                            double realGreen = (1.0 - Math.cos((double)semiLinearDepth * Math.PI * 10.0)) / 2.0;
                            double realBlue = (1.0 - Math.cos((double)semiLinearDepth * Math.PI * 100.0)) / 2.0;
                            red = (byte)(realRed * 255.0);
                            green = (byte)(realGreen * 255.0);
                            blue = (byte)(realBlue * 255.0);
                            break;
                        }
                        default: {
                            int intDepth = (int)(depth * 1.6777215E7f);
                            intBuffer.clear();
                            byte[] colorArray = intBuffer.putInt(intDepth).array();
                            destination[destinationOffset] = -1;
                            red = colorArray[2];
                            green = colorArray[1];
                            blue = colorArray[0];
                            break;
                        }
                    }
                    destination[destinationOffset] = -1;
                    destination[destinationOffset + 1] = blue;
                    destination[destinationOffset + 2] = green;
                    destination[destinationOffset + 3] = red;
                }
            }
        } else {
            throw new RuntimeException("Unsupported image format to decode.");
        }
    }

    static enum DepthConversionMode {
        DEFAULT,
        TRIGONOMETRIC,
        GO_CLIENT;

    }
}

