/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.perflib.heap.Snapshot;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import org.jetbrains.annotations.NotNull;

public abstract class ComputeDominatorAction
extends AnAction {
    @NotNull
    private Snapshot mySnapshot;
    @NotNull
    Project myProject;

    public ComputeDominatorAction(@NotNull Snapshot snapshot, @NotNull Project project) {
        if (snapshot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshot", "com/android/tools/idea/editors/hprof/ComputeDominatorAction", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/ComputeDominatorAction", "<init>"));
        }
        super(null, "Compute Dominators", AndroidIcons.Ddms.AllocationTracker);
        this.mySnapshot = snapshot;
        this.myProject = project;
    }

    public void actionPerformed(AnActionEvent e) {
        ProgressManager.getInstance().run((Task)new ComputeDominatorIndicator(this.myProject));
    }

    public abstract void onDominatorsComputed();

    private class ComputeDominatorIndicator
    extends Task.Modal {
        public ComputeDominatorIndicator(Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/ComputeDominatorAction$ComputeDominatorIndicator", "<init>"));
            }
            super(project, "Computing dominators...", true);
        }

        public void onSuccess() {
            super.onSuccess();
            ComputeDominatorAction.this.onDominatorsComputed();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/hprof/ComputeDominatorAction$ComputeDominatorIndicator", "run"));
            }
            indicator.setIndeterminate(true);
            ComputeDominatorAction.this.mySnapshot.computeDominators();
        }
    }
}

