/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.editors.hprof.HprofViewPanel;
import com.android.tools.perflib.heap.HprofParser;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.io.HprofBuffer;
import com.android.tools.perflib.heap.io.MemoryMappedFileBuffer;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private static final Logger LOG = Logger.getInstance(HprofEditor.class);
    private final JPanel myPanel;
    private boolean myIsValid;

    public HprofEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/HprofEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/hprof/HprofEditor", "<init>"));
        }
        this.myIsValid = true;
        this.myPanel = new JPanel();
        this.parseHprofFileInBackground(project, file);
    }

    private void parseHprofFileInBackground(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/HprofEditor", "parseHprofFileInBackground"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/hprof/HprofEditor", "parseHprofFileInBackground"));
        }
        TaskInfo taskInfo = new TaskInfo(){

            @NotNull
            public String getTitle() {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor$1", "getTitle"));
                }
                return "";
            }

            public String getCancelText() {
                return null;
            }

            public String getCancelTooltipText() {
                return null;
            }

            public boolean isCancellable() {
                return false;
            }

            public String getProcessId() {
                return null;
            }
        };
        final InlineProgressIndicator indicator = new InlineProgressIndicator(true, taskInfo){

            protected void queueRunningUpdate(Runnable update) {
                ApplicationManager.getApplication().invokeLater(update);
            }
        };
        JPanel indicatorWrapper = new JPanel();
        indicatorWrapper.add(indicator.getComponent());
        this.myPanel.setLayout(new GridBagLayout());
        this.myPanel.add(indicatorWrapper);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){
            private Snapshot mySnapshot;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    indicator.setFraction(0.0);
                    indicator.setText("Parsing hprof file...");
                    this.mySnapshot = new HprofParser((HprofBuffer)new MemoryMappedFileBuffer(hprofFile)).parse();
                    indicator.setFraction(0.5);
                    indicator.setText("Computing dominators...");
                    this.mySnapshot.computeDominators();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HprofEditor.this.myPanel.removeAll();
                            HprofEditor.this.myPanel.setLayout(new BorderLayout());
                            HprofEditor.this.myPanel.add((Component)new HprofViewPanel(project, HprofEditor.this, mySnapshot).getComponent(), "Center");
                        }
                    });
                }
                catch (Throwable throwable) {
                    try {
                        LOG.info(throwable);
                        final String errorMessage = "Unexpected error while processing hprof file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                        indicator.cancel();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((Project)project, (String)errorMessage, (String)HprofEditor.this.getName());
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HprofEditor.this.myPanel.removeAll();
                                HprofEditor.this.myPanel.setLayout(new BorderLayout());
                                if (mySnapshot != null) {
                                    HprofEditor.this.myPanel.add((Component)new HprofViewPanel(project, HprofEditor.this, mySnapshot).getComponent(), "Center");
                                }
                            }
                        });
                        throw throwable2;
                    }
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("HprofView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getName"));
        }
        return "HprofView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/hprof/HprofEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/hprof/HprofEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public void setInvalid() {
        this.myIsValid = false;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/HprofEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/HprofEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }
}

