/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.tables;

import com.android.tools.idea.editors.allocations.ColumnTreeBuilder;
import com.android.tools.idea.editors.hprof.tables.SelectionModel;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesTreeView {
    @NotNull
    private Tree myTree;
    @NotNull
    private JComponent myColumnTree;
    @Nullable
    private Comparator<DefaultMutableTreeNode> myComparator;
    private int myCurrentHeapId;
    private boolean myShowRootHandles;

    public ClassesTreeView(final @NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView", "<init>"));
        }
        this.myShowRootHandles = false;
        final DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode("Root node"));
        this.myTree = new Tree((TreeModel)model);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(this.myShowRootHandles);
        this.myTree.setLargeModel(true);
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(@NotNull Heap heap) {
                if (heap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$1", "onHeapChanged"));
                }
                Heap selectedHeap = selectionModel.getHeap();
                ClassesTreeView.this.myCurrentHeapId = selectedHeap.getId();
                assert (model.getRoot() instanceof DefaultMutableTreeNode);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                root.removeAllChildren();
                ArrayList entries = new ArrayList(selectedHeap.getClasses().size() + selectedHeap.getInstancesCount());
                HashSet entriesSet = new HashSet(selectedHeap.getClasses().size() + selectedHeap.getInstancesCount());
                for (ClassObj classObj : selectedHeap.getClasses()) {
                    entriesSet.add((Object)classObj);
                }
                for (Instance instance : selectedHeap.getInstances()) {
                    entriesSet.add((Object)instance.getClassObj());
                }
                entries.addAll(entriesSet);
                ClassObj classToSelect = selectionModel.getClassObj();
                TreeNode nodeToSelect = null;
                for (ClassObj classObj : entries) {
                    root.add(new DefaultMutableTreeNode(new HeapClassObj(classObj, ClassesTreeView.this.myCurrentHeapId)));
                    if (classObj != classToSelect) continue;
                    nodeToSelect = root.getLastChild();
                }
                ClassesTreeView.this.sortTree(root);
                model.nodeStructureChanged(root);
                if (nodeToSelect != null) {
                    TreePath pathToSelect = new TreePath(model.getPathToRoot(nodeToSelect));
                    ClassesTreeView.this.myTree.scrollPathToVisible(pathToSelect);
                    ClassesTreeView.this.myTree.setSelectionPath(pathToSelect);
                } else {
                    selectionModel.setClassObj(null);
                }
            }

            @Override
            public void onClassObjChanged(@Nullable ClassObj classObj) {
            }

            @Override
            public void onInstanceChanged(@Nullable Instance instance) {
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                if (path == null || path.getPathCount() < 2 || !e.isAddedPath()) {
                    selectionModel.setClassObj(null);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
                if (node.getUserObject() instanceof HeapClassObj) {
                    selectionModel.setClassObj(((HeapClassObj)node.getUserObject()).getClassObj());
                }
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class Name").setPreferredWidth(800).setHeaderAlignment(2).setComparator(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
                int comparisonResult = ((HeapClassObj)a.getUserObject()).getSimpleName().compareToIgnoreCase(((HeapClassObj)b.getUserObject()).getSimpleName());
                if (comparisonResult == 0) {
                    return ((HeapClassObj)a.getUserObject()).getClassObj().getClassName().compareToIgnoreCase(((HeapClassObj)b.getUserObject()).getClassObj().getClassName());
                }
                return comparisonResult;
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$13", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof HeapClassObj) {
                    ClassObj clazz = ((HeapClassObj)node.getUserObject()).getClassObj();
                    String name = clazz.getClassName();
                    String pkg = null;
                    int i = name.lastIndexOf(".");
                    if (i != -1) {
                        pkg = name.substring(0, i);
                        name = name.substring(i + 1);
                    }
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (pkg != null) {
                        this.append(" (" + pkg + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                    }
                    this.setTransparentIconBackground(true);
                    this.setIcon(PlatformIcons.CLASS_ICON);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total Count").setPreferredWidth(100).setHeaderAlignment(4).setComparator(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
                return ((HeapClassObj)a.getUserObject()).getClassObj().getInstanceCount() - ((HeapClassObj)b.getUserObject()).getClassObj().getInstanceCount();
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$11", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof HeapClassObj) {
                    this.append(Integer.toString(((HeapClassObj)node.getUserObject()).getClassObj().getInstanceCount()));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Heap Count").setPreferredWidth(100).setHeaderAlignment(4).setComparator(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
                return ((HeapClassObj)a.getUserObject()).getClassObj().getHeapInstancesCount(ClassesTreeView.this.myCurrentHeapId) - ((HeapClassObj)b.getUserObject()).getClassObj().getHeapInstancesCount(ClassesTreeView.this.myCurrentHeapId);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$9", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof HeapClassObj) {
                    this.append(Integer.toString(((HeapClassObj)node.getUserObject()).getClassObj().getHeapInstancesCount(ClassesTreeView.this.myCurrentHeapId)));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Sizeof").setPreferredWidth(80).setHeaderAlignment(4).setComparator(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
                return ((HeapClassObj)a.getUserObject()).getClassObj().getInstanceSize() - ((HeapClassObj)b.getUserObject()).getClassObj().getInstanceSize();
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$7", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof HeapClassObj) {
                    this.append(Integer.toString(((HeapClassObj)node.getUserObject()).getClassObj().getInstanceSize()));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(100).setHeaderAlignment(4).setComparator(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
                return ((HeapClassObj)a.getUserObject()).getClassObj().getShallowSize(ClassesTreeView.this.myCurrentHeapId) - ((HeapClassObj)b.getUserObject()).getClassObj().getShallowSize(ClassesTreeView.this.myCurrentHeapId);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$5", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof HeapClassObj) {
                    this.append(Integer.toString(((HeapClassObj)node.getUserObject()).getClassObj().getShallowSize(ClassesTreeView.this.myCurrentHeapId)));
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Retained Size").setPreferredWidth(120).setHeaderAlignment(4).setComparator(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
                return (int)(((HeapClassObj)a.getUserObject()).getRetainedSize() - ((HeapClassObj)b.getUserObject()).getRetainedSize());
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$3", "customizeCellRenderer"));
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof HeapClassObj) {
                    this.append(Long.toString(((HeapClassObj)node.getUserObject()).getRetainedSize()));
                }
                this.setTextAlign(4);
            }
        }));
        builder.setTreeSorter(new ColumnTreeBuilder.TreeSorter<DefaultMutableTreeNode>(){

            @Override
            public void sort(@NotNull Comparator<DefaultMutableTreeNode> comparator, @NotNull SortOrder sortOrder) {
                if (comparator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$15", "sort"));
                }
                if (sortOrder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortOrder", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$15", "sort"));
                }
                if (ClassesTreeView.this.myComparator != comparator) {
                    ClassesTreeView.this.myComparator = comparator;
                    DefaultTreeModel model = (DefaultTreeModel)ClassesTreeView.this.myTree.getModel();
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                    selectionModel.setSelectionLocked(true);
                    TreePath selectionPath = ClassesTreeView.this.myTree.getSelectionPath();
                    ClassesTreeView.this.sortTree(root);
                    ClassesTreeView.this.myTree.setSelectionPath(selectionPath);
                    ClassesTreeView.this.myTree.scrollPathToVisible(selectionPath);
                    selectionModel.setSelectionLocked(false);
                    model.nodeStructureChanged(root);
                }
            }
        });
        this.myColumnTree = builder.build();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myColumnTree;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView", "getComponent"));
        }
        return jComponent;
    }

    private void sortTree(@NotNull DefaultMutableTreeNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView", "sortTree"));
        }
        if (parent.getChildCount() == 0 || this.myComparator == null) {
            return;
        }
        ArrayList<TreeNode> children = Collections.list(parent.children());
        Collections.sort(children, this.myComparator);
        parent.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : children) {
            parent.add(defaultMutableTreeNode);
            this.sortTree(defaultMutableTreeNode);
        }
    }

    private static class HeapClassObj {
        @NotNull
        private ClassObj myClassObj;
        private long myRetainedSize;
        private String mySimpleName;

        private HeapClassObj(@NotNull ClassObj classObj, int heapId) {
            if (classObj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObj", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$HeapClassObj", "<init>"));
            }
            this.myClassObj = classObj;
            for (Instance instance : this.myClassObj.getHeapInstances(heapId)) {
                this.myRetainedSize += instance.getTotalRetainedSize();
            }
            this.mySimpleName = this.myClassObj.getClassName();
            int index = this.mySimpleName.lastIndexOf(46);
            if (index >= 0 && index < this.mySimpleName.length() - 1) {
                this.mySimpleName = this.mySimpleName.substring(index + 1, this.mySimpleName.length());
            }
        }

        @NotNull
        public ClassObj getClassObj() {
            ClassObj classObj = this.myClassObj;
            if (classObj == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/tables/ClassesTreeView$HeapClassObj", "getClassObj"));
            }
            return classObj;
        }

        public long getRetainedSize() {
            return this.myRetainedSize;
        }

        public String getSimpleName() {
            return this.mySimpleName;
        }
    }
}

