/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ProjectThemeResolver;
import com.android.tools.idea.editors.theme.SeparatedList;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemesListModel
extends AbstractListModel
implements ComboBoxModel {
    private static final JSeparator SEPARATOR = new JSeparator(0);
    public static final String CREATE_NEW_THEME = "Create New Theme";
    public static final String SHOW_ALL_THEMES = "Show all themes";
    public static final String RENAME = "Rename ";
    private SeparatedList myAllItems;
    private Object mySelectedObject;
    private final ArrayList<String> myEditThemeOptions;

    public ThemesListModel(@NotNull Project project, @NotNull ThemeResolver themeResolver, @Nullable String defaultThemeName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemesListModel", "<init>"));
        }
        if (themeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeResolver", "com/android/tools/idea/editors/theme/ThemesListModel", "<init>"));
        }
        this.myEditThemeOptions = new ArrayList();
        this.myEditThemeOptions.add(CREATE_NEW_THEME);
        this.setThemeResolver(project, themeResolver, defaultThemeName);
    }

    public void setThemeResolver(Project project, @NotNull ThemeResolver themeResolver, @Nullable String defaultThemeName) {
        if (themeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeResolver", "com/android/tools/idea/editors/theme/ThemesListModel", "setThemeResolver"));
        }
        ImmutableList<ThemeEditorStyle> defaultThemes = ThemeEditorUtils.getDefaultThemes(themeResolver);
        ImmutableList<ProjectThemeResolver.ThemeWithSource> editableThemes = ProjectThemeResolver.getEditableProjectThemes(project);
        TreeSet<ThemeEditorStyle> temporarySet = new TreeSet<ThemeEditorStyle>(ThemeEditorUtils.STYLE_COMPARATOR);
        for (ProjectThemeResolver.ThemeWithSource theme : editableThemes) {
            temporarySet.add(theme.getTheme());
        }
        temporarySet.addAll((Collection<ThemeEditorStyle>)defaultThemes);
        ImmutableList allThemes = ImmutableList.copyOf(temporarySet);
        ImmutableList externalThemes = allThemes.subList(editableThemes.size(), allThemes.size());
        this.myAllItems = new SeparatedList(SEPARATOR, SeparatedList.group(editableThemes), SeparatedList.group(externalThemes, SHOW_ALL_THEMES), SeparatedList.group(this.myEditThemeOptions));
        if (defaultThemeName != null && themeResolver.getTheme(defaultThemeName) != null) {
            this.setSelectedItem(themeResolver.getTheme(defaultThemeName));
            return;
        }
        if (!allThemes.isEmpty()) {
            this.setSelectedItem(allThemes.get(0));
        } else {
            this.setSelectedItem(null);
        }
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.myAllItems.size();
    }

    @Override
    @NotNull
    public Object getElementAt(int index) {
        Object object = this.myAllItems.get(index);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemesListModel", "getElementAt"));
        }
        return object;
    }

    public static ThemeEditorStyle getStyle(Object object) {
        if (object instanceof ThemeEditorStyle) {
            return (ThemeEditorStyle)object;
        }
        if (object instanceof ProjectThemeResolver.ThemeWithSource) {
            return ((ProjectThemeResolver.ThemeWithSource)object).getTheme();
        }
        return null;
    }

    @Override
    public void setSelectedItem(@Nullable Object anItem) {
        if (anItem instanceof JSeparator) {
            return;
        }
        if (!Objects.equal((Object)this.mySelectedObject, (Object)anItem)) {
            this.mySelectedObject = anItem;
            ThemeEditorStyle selectedStyle = ThemesListModel.getStyle(this.mySelectedObject);
            if (selectedStyle != null) {
                if (this.myEditThemeOptions.size() == 2) {
                    this.myEditThemeOptions.remove(1);
                }
                if (selectedStyle.isProjectStyle()) {
                    this.myEditThemeOptions.add(this.renameOption());
                }
            }
        }
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    @Nullable
    public Object getSelectedItem() {
        return this.mySelectedObject;
    }

    @NotNull
    private String renameOption() {
        ThemeEditorStyle theme = ThemesListModel.getStyle(this.mySelectedObject);
        assert (theme != null) : "Theme should be selected to call renameOption()";
        assert (theme.isProjectStyle());
        String string = RENAME + theme.getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemesListModel", "renameOption"));
        }
        return string;
    }
}

