/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesGrouper;
import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeEditorValue;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.dom.resources.Flag;
import org.jetbrains.annotations.NotNull;
import spantable.CellSpanModel;

public class AttributesTableModel
extends AbstractTableModel
implements CellSpanModel {
    private static final Logger LOG = Logger.getInstance(AttributesTableModel.class);
    private static final Set<Class<?>> WIDE_CLASSES = ImmutableSet.of(Color.class, DrawableDomElement.class);
    protected final List<EditedStyleItem> myAttributes;
    private List<TableLabel> myLabels;
    protected final ThemeEditorStyle mySelectedStyle;
    private final AttributesGrouper.GroupBy myGroupBy;
    private final ResourceResolver myResourceResolver;
    private final Project myProject;
    private final List<ThemePropertyChangedListener> myThemePropertyChangedListeners;
    public final ParentAttribute parentAttribute;
    private ThemeEditorComponent.GoToListener myGoToDefinitionListener;
    private final GoToDefinitionAction myGoToDefinitionAction;
    private final OpenFileAction myOpenFileAction;
    private final ActionListener myGotoParentAction;

    public void setGoToDefinitionListener(ThemeEditorComponent.GoToListener goToDefinitionListener) {
        this.myGoToDefinitionListener = goToDefinitionListener;
    }

    public void addThemePropertyChangedListener(ThemePropertyChangedListener listener) {
        this.myThemePropertyChangedListeners.add(listener);
    }

    public ImmutableSet<String> getDefinedAttributes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EditedStyleItem item : this.myAttributes) {
            builder.add((Object)item.getQualifiedName());
        }
        return builder.build();
    }

    public AttributesTableModel(@NotNull ThemeEditorStyle selectedStyle, @NotNull AttributesGrouper.GroupBy groupBy, @NotNull Configuration configuration, Project project) {
        if (selectedStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedStyle", "com/android/tools/idea/editors/theme/attributes/AttributesTableModel", "<init>"));
        }
        if (groupBy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupBy", "com/android/tools/idea/editors/theme/attributes/AttributesTableModel", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/attributes/AttributesTableModel", "<init>"));
        }
        this.myThemePropertyChangedListeners = new ArrayList<ThemePropertyChangedListener>();
        this.parentAttribute = new ParentAttribute();
        this.myGoToDefinitionAction = new GoToDefinitionAction();
        this.myOpenFileAction = new OpenFileAction();
        this.myGotoParentAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesTableModel.this.myGoToDefinitionListener.goToParent();
            }
        };
        this.myProject = project;
        this.myAttributes = new ArrayList<EditedStyleItem>();
        this.myLabels = new ArrayList<TableLabel>();
        this.mySelectedStyle = selectedStyle;
        this.myGroupBy = groupBy;
        this.myResourceResolver = configuration.getResourceResolver();
        this.reloadContent();
    }

    private void reloadContent() {
        List<EditedStyleItem> rawAttributes = ThemeEditorUtils.resolveAllAttributes(this.mySelectedStyle);
        this.myAttributes.clear();
        this.myLabels = AttributesGrouper.generateLabels(this.myGroupBy, rawAttributes, this.myAttributes);
        this.fireTableStructureChanged();
    }

    public RowContents getRowContents(int rowIndex) {
        if (rowIndex == 0) {
            return this.parentAttribute;
        }
        int offset = 1;
        for (TableLabel label : this.myLabels) {
            int labelRowIndex = label.getRowPosition() + offset;
            if (labelRowIndex < rowIndex) {
                ++offset;
                continue;
            }
            if (labelRowIndex == rowIndex) {
                return new LabelContents(label);
            }
            return new AttributeContents(rowIndex - offset);
        }
        return new AttributeContents(rowIndex - offset);
    }

    public boolean isThemeParentRow(int row) {
        return row == 0;
    }

    @Override
    public int getRowCount() {
        return this.myAttributes.size() + this.myLabels.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getRowContents(rowIndex).getValueAt(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getRowContents(rowIndex).setValueAt(columnIndex, (AttributeEditorValue)aValue);
    }

    public int getColumnSpan(int row, int column) {
        return this.getRowContents(row).getColumnSpan(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getRowContents(rowIndex).isCellEditable(columnIndex);
    }

    public int getRowSpan(int row, int column) {
        return 1;
    }

    public Class<?> getCellClass(int row, int column) {
        return this.getRowContents(row).getCellClass(column);
    }

    protected boolean isReadOnly() {
        return false;
    }

    @NotNull
    public ThemeEditorStyle getSelectedStyle() {
        ThemeEditorStyle themeEditorStyle = this.mySelectedStyle;
        if (themeEditorStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesTableModel", "getSelectedStyle"));
        }
        return themeEditorStyle;
    }

    private class AttributeContents
    implements RowContents {
        private final int myRowIndex;

        public AttributeContents(int rowIndex) {
            this.myRowIndex = rowIndex;
        }

        @Override
        public int getColumnSpan(int column) {
            if (WIDE_CLASSES.contains(this.getCellClass(column))) {
                return column == 0 ? AttributesTableModel.this.getColumnCount() : 0;
            }
            return 1;
        }

        @Override
        public Object getValueAt(int column) {
            return AttributesTableModel.this.myAttributes.get(this.myRowIndex);
        }

        @Override
        public Class<?> getCellClass(int column) {
            EditedStyleItem item = AttributesTableModel.this.myAttributes.get(this.myRowIndex);
            ResourceValue resourceValue = AttributesTableModel.this.mySelectedStyle.getConfiguration().getResourceResolver().resolveResValue((ResourceValue)item.getItemResourceValue());
            if (resourceValue == null) {
                LOG.error("Unable to resolve " + item.getValue());
                return null;
            }
            ResourceType urlType = resourceValue.getResourceType();
            String value = resourceValue.getValue();
            if (urlType == ResourceType.DRAWABLE) {
                return DrawableDomElement.class;
            }
            AttributeDefinition attrDefinition = StyleResolver.getAttributeDefinition(AttributesTableModel.this.mySelectedStyle.getConfiguration(), item.getItemResourceValue());
            if (urlType == ResourceType.COLOR || value != null && value.startsWith("#") && ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
                return Color.class;
            }
            if (urlType == ResourceType.STYLE) {
                return ThemeEditorStyle.class;
            }
            if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Flag)) {
                return Flag.class;
            }
            if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Enum)) {
                return Enum.class;
            }
            if (urlType == ResourceType.INTEGER || ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Integer)) {
                return Integer.class;
            }
            if (urlType == ResourceType.BOOL || ("true".equals(value) || "false".equals(value)) && ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Boolean)) {
                return Boolean.class;
            }
            return EditedStyleItem.class;
        }

        @Override
        public boolean isCellEditable(int column) {
            if (AttributesTableModel.this.isReadOnly()) {
                return false;
            }
            EditedStyleItem item = AttributesTableModel.this.myAttributes.get(this.myRowIndex);
            return (WIDE_CLASSES.contains(this.getCellClass(column)) || column == 1) && item.isPublicAttribute();
        }

        @Override
        public void setValueAt(int column, AttributeEditorValue value) {
            if (value == null) {
                return;
            }
            if (AttributesTableModel.this.mySelectedStyle.isReadOnly()) {
                for (ThemePropertyChangedListener listener : AttributesTableModel.this.myThemePropertyChangedListeners) {
                    listener.attributeChangedOnReadOnlyTheme((EditedStyleItem)this.getValueAt(1), value.getResourceValue());
                }
                return;
            }
            if (this.setAttributeValue(value.getResourceValue(), value.isForceReload())) {
                AttributesTableModel.this.fireTableCellUpdated(this.myRowIndex, column);
            }
        }

        private boolean setAttributeValue(@NotNull String strValue, boolean forceReload) {
            if (strValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strValue", "com/android/tools/idea/editors/theme/attributes/AttributesTableModel$AttributeContents", "setAttributeValue"));
            }
            EditedStyleItem rv = AttributesTableModel.this.myAttributes.get(this.myRowIndex);
            if (strValue.equals(rv.getValue()) && !forceReload) {
                return false;
            }
            String propertyName = rv.getQualifiedName();
            rv.setValue(strValue);
            AttributesTableModel.this.mySelectedStyle.setValue(propertyName, strValue);
            return true;
        }

        @Override
        public ActionListener getGoToDefinitionCallback() {
            VirtualFile virtualFile;
            EditedStyleItem item = (EditedStyleItem)this.getValueAt(1);
            if (this.getCellClass(1) == ThemeEditorStyle.class) {
                AttributesTableModel.this.myGoToDefinitionAction.setItem(item);
                return AttributesTableModel.this.myGoToDefinitionAction;
            }
            VirtualFileManager manager = VirtualFileManager.getInstance();
            ResourceValue resourceValue = AttributesTableModel.this.myResourceResolver.resolveResValue((ResourceValue)item.getItemResourceValue());
            File file = new File(resourceValue.getValue());
            VirtualFile virtualFile2 = virtualFile = file.exists() ? manager.findFileByUrl("file://" + file.getAbsolutePath()) : null;
            if (virtualFile != null) {
                AttributesTableModel.this.myOpenFileAction.setFile(virtualFile);
                return AttributesTableModel.this.myOpenFileAction;
            }
            return null;
        }

        @Override
        public ActionListener getResetCallback() {
            final EditedStyleItem item = (EditedStyleItem)this.getValueAt(0);
            if (!AttributesTableModel.this.mySelectedStyle.isReadOnly() && AttributesTableModel.this.mySelectedStyle.equals(item.getSourceStyle())) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AttributesTableModel.this.mySelectedStyle.removeAttribute(item.getQualifiedName());
                        AttributesTableModel.this.fireTableCellUpdated(AttributeContents.this.myRowIndex, 0);
                    }
                };
            }
            return null;
        }
    }

    private class LabelContents
    implements RowContents {
        private final TableLabel myLabel;

        private LabelContents(TableLabel label) {
            this.myLabel = label;
        }

        @Override
        public int getColumnSpan(int column) {
            return column == 0 ? AttributesTableModel.this.getColumnCount() : 0;
        }

        @Override
        public Object getValueAt(int column) {
            return this.myLabel;
        }

        @Override
        public Class<?> getCellClass(int column) {
            return TableLabel.class;
        }

        @Override
        public boolean isCellEditable(int column) {
            return false;
        }

        @Override
        public void setValueAt(int column, AttributeEditorValue value) {
            throw new RuntimeException(String.format("Tried to setValue at immutable label row of LabelledModel, column = %1$d" + column, new Object[0]));
        }

        @Override
        public ActionListener getGoToDefinitionCallback() {
            return null;
        }

        @Override
        public ActionListener getResetCallback() {
            return null;
        }
    }

    public class ParentAttribute
    implements RowContents {
        @Override
        public int getColumnSpan(int column) {
            return 1;
        }

        @Override
        public Object getValueAt(int column) {
            if (column == 0) {
                return "Theme Parent";
            }
            ThemeEditorStyle parent = AttributesTableModel.this.mySelectedStyle.getParent();
            return parent == null ? "[no parent]" : parent;
        }

        @Override
        public void setValueAt(int column, AttributeEditorValue value) {
            if (column == 0) {
                throw new RuntimeException("Tried to setValue at parent attribute label");
            }
            String newName = value.getResourceValue();
            ThemeEditorStyle parent = AttributesTableModel.this.mySelectedStyle.getParent();
            if (parent == null || !parent.getName().equals(newName)) {
                AttributesTableModel.this.mySelectedStyle.setParent(newName);
                AttributesTableModel.this.fireTableCellUpdated(0, 1);
            }
        }

        @Override
        public Class<?> getCellClass(int column) {
            return column == 0 ? String.class : ParentAttribute.class;
        }

        @Override
        public boolean isCellEditable(int column) {
            return column == 1 && !AttributesTableModel.this.mySelectedStyle.isReadOnly();
        }

        @Override
        public ActionListener getGoToDefinitionCallback() {
            return AttributesTableModel.this.mySelectedStyle.getParent() == null ? null : AttributesTableModel.this.myGotoParentAction;
        }

        @Override
        public ActionListener getResetCallback() {
            return null;
        }
    }

    public static interface RowContents {
        public int getColumnSpan(int var1);

        public Object getValueAt(int var1);

        public void setValueAt(int var1, AttributeEditorValue var2);

        public Class<?> getCellClass(int var1);

        public boolean isCellEditable(int var1);

        public ActionListener getGoToDefinitionCallback();

        public ActionListener getResetCallback();
    }

    public static interface ThemePropertyChangedListener {
        public void attributeChangedOnReadOnlyTheme(EditedStyleItem var1, String var2);
    }

    private class OpenFileAction
    implements ActionListener {
        private VirtualFile myFile = null;
        private final Runnable myOpenFileRunnable = new Runnable(){

            @Override
            public void run() {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(AttributesTableModel.this.myProject, OpenFileAction.this.myFile);
                FileEditorManager.getInstance((Project)AttributesTableModel.this.myProject).openEditor(descriptor, true);
            }
        };

        private OpenFileAction() {
        }

        public void setFile(VirtualFile file) {
            this.myFile = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myFile != null) {
                ApplicationManager.getApplication().invokeLater(this.myOpenFileRunnable);
            }
        }
    }

    private class GoToDefinitionAction
    implements ActionListener {
        private EditedStyleItem myItem = null;

        private GoToDefinitionAction() {
        }

        public void setItem(EditedStyleItem item) {
            this.myItem = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AttributesTableModel.this.myGoToDefinitionListener != null && this.myItem != null) {
                AttributesTableModel.this.myGoToDefinitionListener.goTo(this.myItem);
            }
        }
    }
}

