/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.tools.idea.editors.theme.preview.ThemePreviewBuilder;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ToolbarComponentDefinition
extends ThemePreviewBuilder.ComponentDefinition {
    private boolean myIsAppCompat;

    ToolbarComponentDefinition(boolean isAppCompat) {
        super("Toolbar", ThemePreviewBuilder.ComponentGroup.TOOLBAR, isAppCompat ? "android.support.v7.widget.Toolbar" : "Toolbar");
        this.myIsAppCompat = isAppCompat;
        if (!isAppCompat) {
            this.setApiLevel(21);
            this.set("title", "Toolbar");
            this.set("navigationIcon", "@drawable/abc_ic_ab_back_mtrl_am_alpha");
            this.set("layout_height", "?android:attr/actionBarSize");
        } else {
            this.set("app", "contentInsetStart", "0dp");
            this.set("app", "contentInsetLeft", "0dp");
        }
        String attrPrefix = ToolbarComponentDefinition.getAttrPrefix(isAppCompat);
        this.set("layout_width", "match_parent");
        this.set("layout_height", attrPrefix + "actionBarSize");
        this.set("background", attrPrefix + "colorPrimary");
        this.addAlias("Actionbar");
    }

    private static String getAttrPrefix(boolean isAppCompat) {
        return isAppCompat ? "?attr/" : "?android:attr/";
    }

    @Override
    Element build(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/editors/theme/preview/ToolbarComponentDefinition", "build"));
        }
        Element toolbarComponent = super.build(document);
        if (this.myIsAppCompat) {
            Element navIcon = document.createElement("ImageButton");
            navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
            navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", "?attr/actionBarSize");
            navIcon.setAttribute("style", "?attr/toolbarNavigationButtonStyle");
            navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "src", "@drawable/abc_ic_ab_back_mtrl_am_alpha");
            navIcon.setAttributeNS("http://schemas.android.com/tools/preview/builder", "group", this.group.name());
            toolbarComponent.appendChild(navIcon);
            Element title = document.createElement("TextView");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "text", "Toolbar");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "textAppearance", "@style/TextAppearance.Widget.AppCompat.Toolbar.Title");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", "?attr/actionBarSize");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "gravity", "center_vertical");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "ellipsize", "end");
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "singleLine", "true");
            title.setAttributeNS("http://schemas.android.com/tools/preview/builder", "group", this.group.name());
            toolbarComponent.appendChild(title);
        }
        String attrPrefix = ToolbarComponentDefinition.getAttrPrefix(this.myIsAppCompat);
        Element menuIcon = document.createElement("ImageButton");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "40dp");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", attrPrefix + "actionBarSize");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "background", attrPrefix + "selectableItemBackground");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity", "right");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "src", "@drawable/abc_ic_menu_moreoverflow_mtrl_alpha");
        menuIcon.setAttributeNS("http://schemas.android.com/tools/preview/builder", "group", this.group.name());
        toolbarComponent.appendChild(menuIcon);
        return toolbarComponent;
    }
}

