/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ClassConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconvertibleClassError
extends UnsupportedClassVersionError {
    private final String myFqcn;
    private final int myMinor;
    private final int myMajor;

    public InconvertibleClassError(@Nullable Throwable cause, @NotNull String fqcn, int major, int minor) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/rendering/InconvertibleClassError", "<init>"));
        }
        super(fqcn);
        this.myFqcn = fqcn;
        this.myMajor = major;
        this.myMinor = minor;
        if (cause != null) {
            this.initCause(cause);
        }
    }

    @NotNull
    public String getClassName() {
        String string = this.myFqcn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/InconvertibleClassError", "getClassName"));
        }
        return string;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getMajor() {
        return this.myMajor;
    }

    @NotNull
    public static UnsupportedClassVersionError wrap(@NotNull UnsupportedClassVersionError error, @NotNull String fqcn, byte[] data) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/rendering/InconvertibleClassError", "wrap"));
        }
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/rendering/InconvertibleClassError", "wrap"));
        }
        if (!ClassConverter.isValidClassFile(data)) {
            UnsupportedClassVersionError unsupportedClassVersionError = error;
            if (unsupportedClassVersionError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/InconvertibleClassError", "wrap"));
            }
            return unsupportedClassVersionError;
        }
        short minor = ClassConverter.getMinorVersion(data);
        short major = ClassConverter.getMajorVersion(data);
        InconvertibleClassError inconvertibleClassError = new InconvertibleClassError(error, fqcn, major, minor);
        if (inconvertibleClassError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/InconvertibleClassError", "wrap"));
        }
        return inconvertibleClassError;
    }
}

