/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class LayoutMetadata {
    public static final String DEFAULT_EXPANDABLE_LIST_ITEM = "simple_expandable_list_item_2";
    public static final String DEFAULT_LIST_ITEM = "simple_list_item_2";
    public static final String DEFAULT_SPINNER_ITEM = "simple_spinner_item";
    public static final String KEY_LV_ITEM = "listitem";
    public static final String KEY_LV_HEADER = "listheader";
    public static final String KEY_LV_FOOTER = "listfooter";
    public static final String KEY_FRAGMENT_LAYOUT = "layout";

    private LayoutMetadata() {
    }

    @Nullable
    public static String getProperty(@NotNull XmlPullParser parser, @NotNull String name) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/android/tools/idea/rendering/LayoutMetadata", "getProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutMetadata", "getProperty"));
        }
        String value = parser.getAttributeValue("http://schemas.android.com/tools", name);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }

    @Nullable
    public static String getProperty(@NotNull Node node, @NotNull String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/rendering/LayoutMetadata", "getProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutMetadata", "getProperty"));
        }
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String value = element.getAttributeNS("http://schemas.android.com/tools", name);
            if (value != null && value.isEmpty()) {
                value = null;
            }
            return value;
        }
        return null;
    }

    @Nullable
    public static String getProperty(@NotNull XmlTag node, @NotNull String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/rendering/LayoutMetadata", "getProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutMetadata", "getProperty"));
        }
        String value = node.getAttributeValue(name, "http://schemas.android.com/tools");
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }

    private static String stripLayoutPrefix(String layout) {
        if (layout.startsWith("@android:layout/")) {
            layout = layout.substring("@android:layout/".length());
        } else if (layout.startsWith("@layout/")) {
            layout = layout.substring("@layout/".length());
        }
        return layout;
    }

    @Nullable
    public static AdapterBinding getNodeBinding(@Nullable Object viewObject, @NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/rendering/LayoutMetadata", "getNodeBinding"));
        }
        String header = map.get(KEY_LV_HEADER);
        String footer = map.get(KEY_LV_FOOTER);
        String layout = map.get(KEY_LV_ITEM);
        if (layout != null || header != null || footer != null) {
            int count = 12;
            return LayoutMetadata.getNodeBinding(viewObject, header, footer, layout, count);
        }
        return null;
    }

    @Nullable
    public static AdapterBinding getNodeBinding(@Nullable Object viewObject, @NotNull XmlTag xmlNode) {
        if (xmlNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlNode", "com/android/tools/idea/rendering/LayoutMetadata", "getNodeBinding"));
        }
        String header = LayoutMetadata.getProperty(xmlNode, KEY_LV_HEADER);
        String footer = LayoutMetadata.getProperty(xmlNode, KEY_LV_FOOTER);
        String layout = LayoutMetadata.getProperty(xmlNode, KEY_LV_ITEM);
        if (layout != null || header != null || footer != null) {
            int count = 12;
            if (xmlNode instanceof Element && xmlNode.getName().endsWith("GridView")) {
                Element element = (Element)xmlNode;
                String columns = element.getAttributeNS("http://schemas.android.com/apk/res/android", "numColumns");
                int multiplier = 2;
                if (columns != null && columns.length() > 0 && !columns.equals("auto_fit")) {
                    try {
                        int c = Integer.parseInt(columns);
                        if (c >= 1 && c <= 10) {
                            multiplier = c;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                count *= multiplier;
            }
            return LayoutMetadata.getNodeBinding(viewObject, header, footer, layout, count);
        }
        return null;
    }

    @Nullable
    private static AdapterBinding getNodeBinding(@Nullable Object viewObject, @Nullable String header, @Nullable String footer, @Nullable String layout, int count) {
        if (layout != null || header != null || footer != null) {
            boolean isFramework;
            AdapterBinding binding = new AdapterBinding(count);
            if (header != null) {
                isFramework = header.startsWith("@android:layout/");
                binding.addHeader(new ResourceReference(LayoutMetadata.stripLayoutPrefix(header), isFramework));
            }
            if (footer != null) {
                isFramework = footer.startsWith("@android:layout/");
                binding.addFooter(new ResourceReference(LayoutMetadata.stripLayoutPrefix(footer), isFramework));
            }
            if (layout != null) {
                isFramework = layout.startsWith("@android:layout/");
                if (isFramework) {
                    layout = layout.substring("@android:layout/".length());
                } else if (layout.startsWith("@layout/")) {
                    layout = layout.substring("@layout/".length());
                }
                binding.addItem(new DataBindingItem(layout, isFramework, 1));
            } else if (viewObject != null) {
                String listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass());
                if (listFqcn != null) {
                    if (listFqcn.endsWith("ExpandableListView")) {
                        binding.addItem(new DataBindingItem(DEFAULT_EXPANDABLE_LIST_ITEM, true, 1));
                    } else {
                        binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
                    }
                }
            } else {
                binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
            }
            return binding;
        }
        return null;
    }

    public static void setProperty(final @NotNull Project project, @Nullable String title, final @NotNull XmlFile file, final @NotNull XmlTag element, final @NotNull String name, final @Nullable String namespace, final @Nullable String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/LayoutMetadata", "setProperty"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/LayoutMetadata", "setProperty"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/rendering/LayoutMetadata", "setProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutMetadata", "setProperty"));
        }
        String capitalizedName = StringUtil.capitalize((String)name);
        if (title == null) {
            title = value != null ? String.format("Set %1$s", capitalizedName) : String.format("Clear %1$s", capitalizedName);
        }
        WriteCommandAction action = new WriteCommandAction<Void>(project, title, new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/LayoutMetadata$1", "run"));
                }
                if (value == null) {
                    XmlAttribute attribute = namespace != null ? element.getAttribute(name, namespace) : element.getAttribute(name);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else if (namespace != null) {
                    SuppressLintIntentionAction.ensureNamespaceImported(project, file, namespace);
                    element.setAttribute(name, namespace, value);
                } else {
                    element.setAttribute(name, value);
                }
            }
        };
        action.execute();
        final List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<XmlTag>>(){

            @Nullable
            public List<XmlTag> compute() {
                String id = LintUtils.stripIdPrefix((String)element.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
                if (id.isEmpty()) {
                    return null;
                }
                VirtualFile layoutFile = file.getVirtualFile();
                if (layoutFile != null) {
                    List<VirtualFile> variations = ResourceHelper.getResourceVariations(layoutFile, false);
                    if (variations.isEmpty()) {
                        return null;
                    }
                    PsiManager manager = PsiManager.getInstance((Project)project);
                    ArrayList list = Lists.newArrayList();
                    block0: for (VirtualFile file2 : variations) {
                        PsiFile psiFile = manager.findFile(file2);
                        if (psiFile == null) continue;
                        for (XmlTag tag : PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, XmlTag.class)) {
                            XmlAttribute attribute = tag.getAttribute("id", "http://schemas.android.com/apk/res/android");
                            if (attribute == null || !attribute.getValue().endsWith(id) || !id.equals(LintUtils.stripIdPrefix((String)attribute.getValue()))) continue;
                            list.add(tag);
                            continue block0;
                        }
                    }
                    return list;
                }
                return null;
            }
        });
        if (list != null && !list.isEmpty()) {
            ArrayList affectedFiles = Lists.newArrayList();
            for (XmlTag tag : list) {
                PsiFile psiFile = tag.getContainingFile();
                if (psiFile == null) continue;
                affectedFiles.add(psiFile);
            }
            action = new WriteCommandAction<Void>(project, title, affectedFiles.toArray(new PsiFile[affectedFiles.size()])){

                protected void run(@NotNull Result<Void> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/LayoutMetadata$3", "run"));
                    }
                    for (XmlTag tag : list) {
                        if (value == null) {
                            XmlAttribute attribute = namespace != null ? tag.getAttribute(name, namespace) : tag.getAttribute(name);
                            if (attribute == null) continue;
                            attribute.delete();
                            continue;
                        }
                        if (namespace != null) {
                            SuppressLintIntentionAction.ensureNamespaceImported(project, file, namespace);
                            tag.setAttribute(name, namespace, value);
                            continue;
                        }
                        tag.setAttribute(name, value);
                    }
                }
            };
            action.execute();
        }
    }
}

