/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

class BinPacker {
    static final boolean DEBUG = false;
    private static final boolean PLACE_LEFT = true;
    private static final boolean PLACE_TOP = true;
    private final List<Rectangle> mySpace = new ArrayList<Rectangle>();
    private final int myMinHeight;
    private final int myMinWidth;
    private List<Rectangle> myAllocated;
    private int myIteration;

    BinPacker(int minWidth, int minHeight) {
        this.myMinWidth = minWidth;
        this.myMinHeight = minHeight;
    }

    void addSpace(Rectangle rect) {
        if (rect.width >= this.myMinWidth && rect.height >= this.myMinHeight) {
            this.mySpace.add(rect);
        }
    }

    @Nullable
    Rectangle occupy(int width, int height) {
        int index = this.findBest(width, height);
        if (index == -1) {
            return null;
        }
        return this.split(index, width, height);
    }

    private int findBest(int width, int height) {
        if (this.mySpace.isEmpty()) {
            return -1;
        }
        int bestIndex = -1;
        boolean multipleAtSameY = false;
        int minY = Integer.MAX_VALUE;
        int n = this.mySpace.size();
        for (int i = 0; i < n; ++i) {
            Rectangle rect = this.mySpace.get(i);
            if (rect.y > minY || rect.width < width || rect.height < height) continue;
            if (rect.y < minY) {
                minY = rect.y;
                multipleAtSameY = false;
                bestIndex = i;
                continue;
            }
            if (minY != rect.y) continue;
            multipleAtSameY = true;
        }
        if (!multipleAtSameY) {
            return bestIndex;
        }
        bestIndex = -1;
        int bestShortDistance = Integer.MAX_VALUE;
        int bestLongDistance = Integer.MAX_VALUE;
        int n2 = this.mySpace.size();
        for (int i = 0; i < n2; ++i) {
            int distance;
            Rectangle rect = this.mySpace.get(i);
            if (rect.y != minY || rect.width < width || rect.height < height) continue;
            if (width < height) {
                distance = rect.width - width;
                if (distance >= bestShortDistance && (distance != bestShortDistance || rect.height - height >= bestLongDistance)) continue;
                bestShortDistance = distance;
                bestLongDistance = rect.height - height;
                bestIndex = i;
                continue;
            }
            distance = rect.width - width;
            if (distance >= bestShortDistance && (distance != bestShortDistance || rect.height - height >= bestLongDistance)) continue;
            bestShortDistance = distance;
            bestLongDistance = rect.height - height;
            bestIndex = i;
        }
        return bestIndex;
    }

    private void removeRect(int index) {
        assert (!this.mySpace.isEmpty());
        int lastIndex = this.mySpace.size() - 1;
        if (index != lastIndex) {
            Rectangle temp = this.mySpace.get(index);
            this.mySpace.set(index, this.mySpace.get(lastIndex));
            this.mySpace.set(lastIndex, temp);
        }
        this.mySpace.remove(lastIndex);
    }

    private Rectangle split(int index, int width, int height) {
        Rectangle rect = this.mySpace.get(index);
        assert (rect.width >= width && rect.height >= height) : rect;
        Rectangle r = new Rectangle();
        r.x = rect.x;
        r.y = rect.y;
        r.width = width;
        r.height = height;
        for (int i = 0; i < this.mySpace.size(); ++i) {
            Rectangle other = this.mySpace.get(i);
            if (!other.intersects(r)) continue;
            this.removeRect(i);
            --i;
        }
        int remainingHeight = rect.height - height;
        int remainingWidth = rect.width - width;
        if (remainingHeight >= this.myMinHeight) {
            this.mySpace.add(new Rectangle(rect.x, rect.y + height, width, remainingHeight));
        }
        if (remainingWidth >= this.myMinWidth) {
            this.mySpace.add(new Rectangle(rect.x + width, rect.y, remainingWidth, rect.height));
        }
        if (remainingHeight >= this.myMinHeight) {
            this.mySpace.add(new Rectangle(rect.x, rect.y + height, rect.width, remainingHeight));
        }
        if (remainingWidth >= this.myMinWidth) {
            this.mySpace.add(new Rectangle(rect.x + width, rect.y, remainingWidth, height));
        }
        block1: for (int i = 0; i < this.mySpace.size() - 1; ++i) {
            for (int j = i + 1; j < this.mySpace.size(); ++j) {
                Rectangle iRect = this.mySpace.get(i);
                Rectangle jRect = this.mySpace.get(j);
                if (jRect.contains(iRect)) {
                    this.removeRect(i);
                    --i;
                    continue block1;
                }
                if (!iRect.contains(jRect)) continue;
                this.removeRect(j);
                --j;
            }
        }
        return r;
    }

    void dumpDiagnostics() {
    }

    void paintDiagnostics(Graphics2D g) {
    }
}

