/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote;

import com.android.annotations.NonNull;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.AddonsListFetcher;
import com.android.tools.idea.sdk.remote.internal.DownloadCache;
import com.android.tools.idea.sdk.remote.internal.NullTaskMonitor;
import com.android.tools.idea.sdk.remote.internal.sources.SdkAddonSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkAddonsListConstants;
import com.android.tools.idea.sdk.remote.internal.sources.SdkRepoSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSourceCategory;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSysImgSource;
import com.android.tools.idea.sdk.remote.internal.updater.SettingsController;
import com.android.utils.ILogger;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;

public class RemoteSdk {
    public static final long DEFAULT_EXPIRATION_PERIOD_MS = 86400000L;
    private final SettingsController mSettingsController;
    private final SdkSources mSdkSources = new SdkSources();
    private long mSdkSourceTS;
    private DownloadCache mDownloadCache;

    public RemoteSdk(ILogger logger) {
        this(new SettingsController(logger));
    }

    public RemoteSdk(SettingsController settingsController) {
        this.mSettingsController = settingsController;
    }

    @NonNull
    public Multimap<PkgType, RemotePkgInfo> fetch(@NonNull SdkSources sources, @NonNull ILogger logger) {
        HashMultimap remotes = HashMultimap.create();
        boolean forceHttp = this.mSettingsController.getSettings().getForceHttp();
        for (SdkSource source : sources.getAllSources()) {
            source.load(this.getDownloadCache(), new NullTaskMonitor(logger), forceHttp);
            RemotePkgInfo[] pkgs = source.getPackages();
            if (pkgs == null) continue;
            for (RemotePkgInfo p : pkgs) {
                remotes.put((Object)p.getPkgDesc().getType(), (Object)p);
            }
        }
        return remotes;
    }

    @NonNull
    public SdkSources fetchSources(long expirationDelayMs, @NonNull ILogger logger) {
        boolean expired;
        long now = System.currentTimeMillis();
        boolean bl = expired = now - this.mSdkSourceTS > expirationDelayMs;
        if (expired || !this.mSdkSources.sourcesLoaded(SdkSourceCategory.ANDROID_REPO)) {
            String baseUrl = System.getenv("SDK_TEST_BASE_URL");
            if (baseUrl == null || baseUrl.length() <= 0 || !baseUrl.endsWith("/")) {
                baseUrl = "https://dl.google.com/android/repository/";
            }
            this.mSdkSources.set(SdkSourceCategory.ANDROID_REPO, Lists.newArrayList((Object[])new SdkSource[]{new SdkRepoSource(baseUrl, SdkSourceCategory.ANDROID_REPO.getUiName())}));
        }
        if (!this.mSdkSources.sourcesLoaded(SdkSourceCategory.USER_ADDONS)) {
            this.mSdkSources.loadUserAddons(logger);
        }
        if (expired || !this.mSdkSources.sourcesLoaded(SdkSourceCategory.ADDONS_3RD_PARTY)) {
            NullTaskMonitor tempMonitor = new NullTaskMonitor(logger);
            String url = SdkAddonsListConstants.URL_ADDON_LIST;
            String baseUrl = System.getenv("SDK_TEST_BASE_URL");
            if (baseUrl != null) {
                if (baseUrl.length() > 0 && baseUrl.endsWith("/")) {
                    if (url.startsWith("https://dl.google.com/android/repository/")) {
                        url = baseUrl + url.substring("https://dl.google.com/android/repository/".length());
                    }
                } else {
                    tempMonitor.logError("Ignoring invalid SDK_TEST_BASE_URL: %1$s", baseUrl);
                }
            }
            if (this.mSettingsController.getSettings().getForceHttp()) {
                url = url.replaceAll("https://", "http://");
            }
            boolean fetch3rdParties = System.getenv("SDK_SKIP_3RD_PARTIES") == null;
            AddonsListFetcher fetcher = new AddonsListFetcher();
            AddonsListFetcher.Site[] sites = fetcher.fetch(url, this.getDownloadCache(), tempMonitor);
            if (sites != null) {
                this.mSdkSources.removeAll(SdkSourceCategory.ADDONS_3RD_PARTY);
                if (fetch3rdParties) {
                    ArrayList newSources = Lists.newArrayList();
                    block4: for (AddonsListFetcher.Site s : sites) {
                        switch (s.getType()) {
                            case ADDON_SITE: {
                                newSources.add(new SdkAddonSource(s.getUrl(), s.getUiName()));
                                continue block4;
                            }
                            case SYS_IMG_SITE: {
                                newSources.add(new SdkSysImgSource(s.getUrl(), s.getUiName()));
                            }
                        }
                    }
                    this.mSdkSources.set(SdkSourceCategory.ADDONS_3RD_PARTY, newSources);
                }
            }
        }
        this.mSdkSourceTS = now;
        return this.mSdkSources;
    }

    protected DownloadCache getDownloadCache() {
        if (this.mDownloadCache == null) {
            this.mDownloadCache = new DownloadCache(this.mSettingsController.getSettings().getUseDownloadCache() ? DownloadCache.Strategy.FRESH_CACHE : DownloadCache.Strategy.DIRECT);
        }
        return this.mDownloadCache;
    }
}

