/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.idea.sdk.remote.internal.CanceledByUserException;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.UserCredentials;
import com.android.utils.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

class UrlOpener {
    private static final boolean DEBUG = System.getenv("ANDROID_DEBUG_URL_OPENER") != null;
    private static Map<String, UserCredentials> sRealmCache = new HashMap<String, UserCredentials>();
    private static int sConnectionTimeoutMs;
    private static int sSocketTimeoutMs;

    private UrlOpener() {
    }

    @NonNull
    static Pair<InputStream, HttpResponse> openUrl(@NonNull String url, boolean needsMarkResetSupport, @NonNull ITaskMonitor monitor, @Nullable Header[] headers) throws IOException, CanceledByUserException {
        InputStream is;
        Pair result;
        block18: {
            Throwable fallbackOnJavaUrlConnect = null;
            result = null;
            try {
                result = UrlOpener.openWithHttpClient(url, monitor, headers);
            }
            catch (UnknownHostException e) {
                throw new IOException("Unknown Host " + e.getMessage(), e);
            }
            catch (ClientProtocolException e) {
                fallbackOnJavaUrlConnect = e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (CanceledByUserException e) {
                throw e;
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.out.printf("[HttpClient Error] %s : %s\n", url, e.toString());
                }
                fallbackOnJavaUrlConnect = e;
            }
            if (fallbackOnJavaUrlConnect != null) {
                try {
                    result = UrlOpener.openWithUrl(url, headers);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!DEBUG || fallbackOnJavaUrlConnect.equals(e)) break block18;
                    System.out.printf("[Url Error] %s : %s\n", url, e.toString());
                }
            }
        }
        if (result != null && needsMarkResetSupport && (is = (InputStream)result.getFirst()) != null && !is.markSupported()) {
            try {
                InputStream is2 = UrlOpener.toByteArrayInputStream(is);
                if (is2 != null) {
                    result = Pair.of((Object)is2, (Object)result.getSecond());
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            BasicHttpResponse outResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 0), 420, "");
            result = Pair.of(null, (Object)outResponse);
        }
        return result;
    }

    private static InputStream toByteArrayInputStream(InputStream is) throws IOException {
        int n;
        int inc = 4096;
        int curr = 0;
        byte[] result = new byte[inc];
        while ((n = is.read(result, curr, result.length - curr)) != -1) {
            if ((curr += n) != result.length) continue;
            byte[] temp = new byte[curr + inc];
            System.arraycopy(result, 0, temp, 0, curr);
            result = temp;
        }
        return new ByteArrayInputStream(result, 0, curr);
    }

    private static Pair<InputStream, HttpResponse> openWithUrl(String url, Header[] inHeaders) throws IOException {
        BufferedInputStream is;
        int code;
        URLConnection c;
        URL u;
        block6: {
            u = new URL(url);
            c = u.openConnection();
            c.setConnectTimeout(sConnectionTimeoutMs);
            c.setReadTimeout(sSocketTimeoutMs);
            if (inHeaders != null) {
                for (Header header : inHeaders) {
                    c.setRequestProperty(header.getName(), header.getValue());
                }
            }
            code = 200;
            if (c instanceof HttpURLConnection) {
                code = ((HttpURLConnection)c).getResponseCode();
            }
            is = null;
            try {
                is = new BufferedInputStream(c.getInputStream());
            }
            catch (Exception ignore) {
                if (is != null || code != 200) break block6;
                code = 404;
            }
        }
        BasicHttpResponse outResponse = new BasicHttpResponse(new ProtocolVersion(u.getProtocol(), 1, 0), code, "");
        Map<String, List<String>> outHeaderMap = c.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : outHeaderMap.entrySet()) {
            List<String> values;
            String name = entry.getKey();
            if (name == null || (values = entry.getValue()).isEmpty()) continue;
            outResponse.setHeader(name, values.get(0));
        }
        return Pair.of((Object)is, (Object)outResponse);
    }

    @NonNull
    private static Pair<InputStream, HttpResponse> openWithHttpClient(@NonNull String url, @NonNull ITaskMonitor monitor, Header[] inHeaders) throws IOException, CanceledByUserException {
        UserCredentials result = null;
        String realm = null;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)sConnectionTimeoutMs);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)sSocketTimeoutMs);
        final DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)params);
        BasicHttpContext localContext = new BasicHttpContext();
        HttpGet httpGet = new HttpGet(url);
        if (inHeaders != null) {
            for (Header header : inHeaders) {
                httpGet.addHeader(header);
            }
        }
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        ArrayList<String> authpref = new ArrayList<String>();
        authpref.add("Basic");
        authpref.add("Digest");
        authpref.add("NTLM");
        httpClient.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
        httpClient.getParams().setParameter("http.auth.target-scheme-pref", authpref);
        if (DEBUG) {
            try {
                URI uri = new URI(url);
                ProxySelector sel = routePlanner.getProxySelector();
                if (sel != null && uri.getScheme().startsWith("httP")) {
                    List<Proxy> list = sel.select(uri);
                    System.out.printf("SdkLib.UrlOpener:\n  Connect to: %s\n  Proxy List: %s\n", url, list == null ? "(null)" : Arrays.toString(list.toArray()));
                }
            }
            catch (Exception e) {
                System.out.printf("SdkLib.UrlOpener: Failed to get proxy info for %s: %s\n", url, e.toString());
            }
        }
        boolean trying = true;
        while (trying) {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)localContext);
            int statusCode = response.getStatusLine().getStatusCode();
            if (DEBUG) {
                System.out.printf("  Status: %d\n", statusCode);
            }
            AuthState authenticationState = null;
            if (statusCode == 401) {
                authenticationState = (AuthState)localContext.getAttribute("http.auth.target-scope");
            }
            if (statusCode == 407) {
                authenticationState = (AuthState)localContext.getAttribute("http.auth.proxy-scope");
            }
            if ((statusCode == 200 || statusCode == 304) && realm != null && result != null) {
                sRealmCache.put(realm, result);
            }
            if (authenticationState != null) {
                AuthScope authScope = authenticationState.getAuthScope();
                if (realm != null && !realm.equals(authScope.getRealm())) {
                    sRealmCache.put(realm, result);
                }
                if (sRealmCache.containsKey(realm = authScope.getRealm())) {
                    result = sRealmCache.get(realm);
                } else {
                    result = monitor.displayLoginCredentialsPrompt("Site Authentication", "Please login to the following domain: " + realm + "\n\nServer requiring authentication:\n" + authScope.getHost());
                    if (result == null) {
                        throw new CanceledByUserException("User canceled login dialog.");
                    }
                }
                String user = result.getUserName();
                String password = result.getPassword();
                String workstation = result.getWorkstation();
                String domain = result.getDomain();
                if (user != null && user.length() > 0) {
                    NTCredentials credentials = new NTCredentials(user, password, workstation, domain);
                    httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
                    trying = true;
                } else {
                    trying = false;
                }
            } else {
                trying = false;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (trying) {
                    entity.getContent().close();
                    continue;
                }
                FilterInputStream is = new FilterInputStream(entity.getContent()){

                    @Override
                    public void close() throws IOException {
                        httpClient.getConnectionManager().shutdown();
                        super.close();
                    }
                };
                BasicHttpResponse outResponse = new BasicHttpResponse(response.getStatusLine());
                outResponse.setHeaders(response.getAllHeaders());
                outResponse.setLocale(response.getLocale());
                return Pair.of((Object)is, (Object)outResponse);
            }
            if (statusCode != 304) continue;
            BasicHttpResponse outResponse = new BasicHttpResponse(response.getStatusLine());
            outResponse.setHeaders(response.getAllHeaders());
            outResponse.setLocale(response.getLocale());
            return Pair.of(null, (Object)outResponse);
        }
        httpClient.getConnectionManager().shutdown();
        throw new FileNotFoundException(url);
    }

    static {
        if (DEBUG) {
            Properties props = System.getProperties();
            for (String key : new String[]{"http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort"}) {
                String prop = props.getProperty(key);
                if (prop == null) continue;
                System.out.printf("SdkLib.UrlOpener Java.Prop %s='%s'\n", key, prop);
            }
        }
        try {
            sConnectionTimeoutMs = Integer.parseInt(System.getenv("ANDROID_SDKMAN_CONN_TIMEOUT"));
        }
        catch (Exception ignore) {
            sConnectionTimeoutMs = 120000;
        }
        try {
            sSocketTimeoutMs = Integer.parseInt(System.getenv("ANDROID_SDKMAN_READ_TIMEOUT"));
        }
        catch (Exception ignore) {
            sSocketTimeoutMs = 60000;
        }
    }
}

