/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerAnalyticsImpl
extends UsageTracker {
    private static final Logger LOG = Logger.getInstance(UsageTrackerAnalyticsImpl.class);
    @NonNls
    private static final String ANALYTICS_URL = "https://ssl.google-analytics.com/collect";
    @NonNls
    private static final String ANAYLTICS_ID = "UA-19996407-3";
    @NonNls
    private static final String ANALYTICS_APP = "Android Studio";
    private static final List<? extends NameValuePair> analyticsBaseData = ImmutableList.of((Object)new BasicNameValuePair("v", "1"), (Object)new BasicNameValuePair("tid", "UA-19996407-3"), (Object)new BasicNameValuePair("t", "event"), (Object)new BasicNameValuePair("an", "Android Studio"), (Object)new BasicNameValuePair("av", ApplicationInfo.getInstance().getFullVersion()), (Object)new BasicNameValuePair("cid", UpdateChecker.getInstallationUID((PropertiesComponent)PropertiesComponent.getInstance())));

    @Override
    public void trackEvent(@NotNull String eventCategory, @NotNull String eventAction, @Nullable String eventLabel, @Nullable Integer eventValue) {
        if (eventCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventCategory", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackEvent"));
        }
        if (eventAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventAction", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackEvent"));
        }
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            return;
        }
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        ArrayList postData = Lists.newArrayList(analyticsBaseData);
        postData.add(new BasicNameValuePair("ec", eventCategory));
        postData.add(new BasicNameValuePair("ea", eventAction));
        if (!StringUtil.isEmpty((String)eventLabel)) {
            postData.add(new BasicNameValuePair("el", eventLabel));
        }
        if (eventValue != null) {
            if (eventValue < 0) {
                LOG.debug("Attempting to send negative event value to the analytics server");
            }
            postData.add(new BasicNameValuePair("ev", eventValue.toString()));
        }
        UsageTrackerAnalyticsImpl.sendPing(postData);
    }

    private static void sendPing(final @NotNull List<? extends NameValuePair> postData) {
        if (postData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postData", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "sendPing"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost request = new HttpPost(UsageTrackerAnalyticsImpl.ANALYTICS_URL);
                try {
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(postData));
                    CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                    StatusLine status = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    if (status.getStatusCode() >= 300) {
                        LOG.debug("Non 200 status code : " + status.getStatusCode() + " - " + status.getReasonPhrase());
                    }
                }
                catch (IOException e) {
                    LOG.debug("IOException during Analytics Ping", new Object[]{e.getMessage()});
                }
                finally {
                    HttpClientUtils.closeQuietly((HttpClient)client);
                }
            }
        });
    }
}

