/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.parse.StringFileAdapter;
import com.android.tools.idea.templates.recipe.RecipeContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="recipe")
public final class Recipe {
    @XmlElements(value={@XmlElement(name="copy", type=CopyInstruction.class), @XmlElement(name="instantiate", type=InstantiateInstruction.class), @XmlElement(name="merge", type=MergeInstruction.class), @XmlElement(name="mkdir", type=MkDirInstruction.class), @XmlElement(name="dependency", type=DependencyInstruction.class), @XmlElement(name="open", type=OpenInstruction.class)})
    private List<RecipeInstruction> instructions = Lists.newArrayList();
    @NotNull
    private final List<String> myDependencies = Lists.newArrayList();
    @NotNull
    private final List<File> myFilesToModify = Lists.newArrayList();
    @NotNull
    private final List<File> myFilesToOpen = Lists.newArrayList();

    @NotNull
    public List<String> getDependencies() {
        List<String> list = this.myDependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/Recipe", "getDependencies"));
        }
        return list;
    }

    @NotNull
    public List<File> getFilesToModify() {
        List<File> list = this.myFilesToModify;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/Recipe", "getFilesToModify"));
        }
        return list;
    }

    @NotNull
    public List<File> getFilesToOpen() {
        List<File> list = this.myFilesToOpen;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/Recipe", "getFilesToOpen"));
        }
        return list;
    }

    public static Recipe parse(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/android/tools/idea/templates/recipe/Recipe", "parse"));
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Recipe.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (Recipe)u.unmarshal(xmlReader);
    }

    @NotNull
    private static File cloneWithourFreemarkerSuffix(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/Recipe", "cloneWithourFreemarkerSuffix"));
        }
        File clone = new File(file.getPath());
        File file2 = TemplateUtils.stripSuffix(clone, ".ftl");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/Recipe", "cloneWithourFreemarkerSuffix"));
        }
        return file2;
    }

    public void execute(@NotNull RecipeContext recipeContext) {
        if (recipeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recipeContext", "com/android/tools/idea/templates/recipe/Recipe", "execute"));
        }
        for (RecipeInstruction instruction : this.instructions) {
            instruction.execute(recipeContext);
        }
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        this.instructions.add(new FinalInstruction());
        for (RecipeInstruction instruction : this.instructions) {
            instruction.addDependenciesInto(this.myDependencies);
            instruction.addFilesToModifyInto(this.myFilesToModify);
            instruction.addFilesToOpenInto(this.myFilesToOpen);
        }
    }

    private static final class FinalInstruction
    extends RecipeInstruction {
        private FinalInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.updateAndSyncGradle();
        }
    }

    private static final class DependencyInstruction
    extends RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String mavenUrl;

        private DependencyInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.addDependency(this.mavenUrl);
        }

        @Override
        public void addDependenciesInto(@NotNull List<String> dependencies) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/recipe/Recipe$DependencyInstruction", "addDependenciesInto"));
            }
            dependencies.add(this.mavenUrl);
        }
    }

    private static final class OpenInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File file;

        private OpenInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.open(this.file);
        }

        @Override
        public void addFilesToOpenInto(@NotNull List<File> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/recipe/Recipe$OpenInstruction", "addFilesToOpenInto"));
            }
            files.add(this.file);
        }
    }

    private static final class MkDirInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File at;

        private MkDirInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.mkDir(this.at);
        }
    }

    private static final class MergeInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private MergeInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            assert (this.to != null);
            context.merge(this.from, this.to);
        }

        @Override
        public void addFilesToModifyInto(@NotNull List<File> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/recipe/Recipe$MergeInstruction", "addFilesToModifyInto"));
            }
            files.add(this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithourFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class InstantiateInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private InstantiateInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            assert (this.to != null);
            context.instantiate(this.from, this.to);
        }

        @Override
        public void addFilesToModifyInto(@NotNull List<File> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/recipe/Recipe$InstantiateInstruction", "addFilesToModifyInto"));
            }
            files.add(this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithourFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class CopyInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private CopyInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            assert (this.to != null);
            context.copy(this.from, this.to);
        }

        @Override
        public void addFilesToModifyInto(@NotNull List<File> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/recipe/Recipe$CopyInstruction", "addFilesToModifyInto"));
            }
            files.add(this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithourFreemarkerSuffix(this.from);
            }
        }
    }

    private static abstract class RecipeInstruction {
        private RecipeInstruction() {
        }

        public abstract void execute(RecipeContext var1);

        public void addDependenciesInto(@NotNull List<String> dependencies) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/recipe/Recipe$RecipeInstruction", "addDependenciesInto"));
            }
        }

        public void addFilesToModifyInto(@NotNull List<File> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/recipe/Recipe$RecipeInstruction", "addFilesToModifyInto"));
            }
        }

        public void addFilesToOpenInto(@NotNull List<File> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/recipe/Recipe$RecipeInstruction", "addFilesToOpenInto"));
            }
        }
    }
}

