/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.Observable;
import com.android.tools.idea.ui.properties.ObservableProperty;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.collections.ObservableList;
import com.android.tools.idea.ui.properties.exceptions.BindingCycleException;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpressions;
import com.android.tools.idea.ui.properties.expressions.list.ListExpression;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class BindingsManager {
    private static final int MAX_CYCLE_COUNT = 10;
    public static final InvokeStrategy APPLICATION_INVOKE_LATER_STRATEGY = new InvokeStrategy(){

        @Override
        public void invoke(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BindingsManager$1", "invoke"));
            }
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any());
        }
    };
    public static final InvokeStrategy SWING_INVOKE_LATER_STRATEGY = new InvokeStrategy(){

        @Override
        public void invoke(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BindingsManager$2", "invoke"));
            }
            SwingUtilities.invokeLater(runnable);
        }
    };
    public static final InvokeStrategy INVOKE_IMMEDIATELY_STRATEGY = new InvokeStrategy(){

        @Override
        public void invoke(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BindingsManager$3", "invoke"));
            }
            runnable.run();
        }
    };
    private final Map<ObservableProperty<?>, OneWayBinding<?>> myOneWayBindings = Maps.newHashMap();
    private final Table<ObservableProperty<?>, ObservableProperty<?>, TwoWayBinding<?>> myTwoWayBindings = HashBasedTable.create();
    private final List<ListBindingWrapper> myListWrappers = Lists.newArrayList();
    private final Queue<Updater> myUpdaters = Queues.newArrayDeque();
    private final Queue<Updater> myDeferredUpdaters = Queues.newArrayDeque();
    private boolean myUpdateInProgress;
    private int myCycleCount;
    private final InvokeStrategy myInvokeStrategy;

    public BindingsManager() {
        this(APPLICATION_INVOKE_LATER_STRATEGY);
    }

    public BindingsManager(InvokeStrategy invokeStrategy) {
        this.myInvokeStrategy = invokeStrategy;
    }

    public <T> void bind(@NotNull ObservableProperty<T> dest, @NotNull ObservableValue<T> src) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        this.bind(dest, src, BooleanExpressions.TRUE);
    }

    public <T> void bind(@NotNull ObservableProperty<T> dest, @NotNull ObservableValue<T> src, @NotNull ObservableValue<Boolean> enabled) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        if (enabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabled", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        this.release(dest);
        this.myOneWayBindings.put(dest, new OneWayBinding<T>(dest, src, enabled));
    }

    public <T> void bindTwoWay(@NotNull ObservableProperty<T> first, @NotNull ObservableProperty<T> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/android/tools/idea/ui/properties/BindingsManager", "bindTwoWay"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/android/tools/idea/ui/properties/BindingsManager", "bindTwoWay"));
        }
        this.releaseTwoWay(first, second);
        this.myTwoWayBindings.put(first, second, new TwoWayBinding<T>(first, second));
    }

    public <S, D> void bindList(@NotNull ObservableList<D> destList, @NotNull ListExpression<S, D> srcExpression) {
        if (destList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destList", "com/android/tools/idea/ui/properties/BindingsManager", "bindList"));
        }
        if (srcExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcExpression", "com/android/tools/idea/ui/properties/BindingsManager", "bindList"));
        }
        this.releaseList(destList);
        this.myListWrappers.add(new ListBindingWrapper(destList, new ListBinding(destList, srcExpression)));
    }

    public void release(@NotNull ObservableProperty<?> dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/ui/properties/BindingsManager", "release"));
        }
        OneWayBinding<?> oneWayBinding = this.myOneWayBindings.get(dest);
        if (oneWayBinding == null) {
            return;
        }
        oneWayBinding.dispose();
        this.myOneWayBindings.remove(dest);
    }

    public <T> void releaseTwoWay(@NotNull ObservableProperty<T> first, @NotNull ObservableProperty<T> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/android/tools/idea/ui/properties/BindingsManager", "releaseTwoWay"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/android/tools/idea/ui/properties/BindingsManager", "releaseTwoWay"));
        }
        TwoWayBinding twoWayBinding = (TwoWayBinding)this.myTwoWayBindings.get(first, second);
        if (twoWayBinding == null) {
            return;
        }
        twoWayBinding.dispose();
        this.myTwoWayBindings.remove(first, second);
    }

    public <T> void releaseList(@NotNull ObservableList<T> destList) {
        if (destList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destList", "com/android/tools/idea/ui/properties/BindingsManager", "releaseList"));
        }
        Iterator<ListBindingWrapper> i = this.myListWrappers.iterator();
        while (i.hasNext()) {
            ListBindingWrapper wrapper = i.next();
            if (wrapper.getList() != destList) continue;
            wrapper.getBinding().dispose();
            i.remove();
            break;
        }
    }

    public void releaseAll() {
        for (OneWayBinding<?> oneWayBinding : this.myOneWayBindings.values()) {
            oneWayBinding.dispose();
        }
        this.myOneWayBindings.clear();
        for (TwoWayBinding twoWayBinding : this.myTwoWayBindings.values()) {
            twoWayBinding.dispose();
        }
        this.myTwoWayBindings.clear();
        for (ListBindingWrapper listWrapper : this.myListWrappers) {
            listWrapper.getBinding().dispose();
        }
        this.myListWrappers.clear();
    }

    private void enqueueUpdater(@NotNull Updater updater) {
        if (updater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/android/tools/idea/ui/properties/BindingsManager", "enqueueUpdater"));
        }
        if (this.myUpdateInProgress) {
            if (!this.myDeferredUpdaters.contains(updater)) {
                this.myDeferredUpdaters.add(updater);
            }
            return;
        }
        boolean shouldInvoke = this.myUpdaters.isEmpty();
        if (!this.myUpdaters.contains(updater)) {
            this.myUpdaters.add(updater);
        }
        if (shouldInvoke) {
            this.invokeUpdate();
        }
    }

    private void invokeUpdate() {
        this.myInvokeStrategy.invoke(new Runnable(){

            @Override
            public void run() {
                BindingsManager.this.myUpdateInProgress = true;
                for (Updater propertyUpdater : BindingsManager.this.myUpdaters) {
                    propertyUpdater.update();
                }
                BindingsManager.this.myUpdaters.clear();
                BindingsManager.this.myUpdateInProgress = false;
                if (!BindingsManager.this.myDeferredUpdaters.isEmpty()) {
                    BindingsManager.this.myCycleCount++;
                    if (BindingsManager.this.myCycleCount > 10) {
                        throw new BindingCycleException();
                    }
                    BindingsManager.this.myUpdaters.addAll(BindingsManager.this.myDeferredUpdaters);
                    BindingsManager.this.myDeferredUpdaters.clear();
                    BindingsManager.this.invokeUpdate();
                } else {
                    BindingsManager.this.myCycleCount = 0;
                }
            }
        });
    }

    private static final class ListBindingWrapper {
        private ObservableList myList;
        private ListBinding myBinding;

        public ListBindingWrapper(ObservableList list, ListBinding binding) {
            this.myList = list;
            this.myBinding = binding;
        }

        public ObservableList getList() {
            return this.myList;
        }

        public ListBinding getBinding() {
            return this.myBinding;
        }
    }

    private static final class PropertyUpdater<T>
    implements Updater {
        private final ObservableProperty<T> myDest;
        private final ObservableValue<T> mySrc;

        public PropertyUpdater(ObservableProperty<T> dest, ObservableValue<T> src) {
            this.myDest = dest;
            this.mySrc = src;
        }

        @Override
        public void update() {
            this.myDest.set(this.mySrc.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyUpdater that = (PropertyUpdater)o;
            return Objects.equal(this.myDest, that.myDest) && Objects.equal(this.mySrc, that.mySrc);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myDest, this.mySrc});
        }
    }

    private class ListBinding<S, D>
    extends InvalidationListener
    implements Updater {
        private final ObservableList<D> myDestList;
        private final ListExpression<S, D> mySrcExpression;

        private ListBinding(ObservableList<D> destList, ListExpression<S, D> srcExpression) {
            this.myDestList = destList;
            this.mySrcExpression = srcExpression;
            srcExpression.addListener(this);
            this.onInvalidated(srcExpression);
        }

        @Override
        protected void onInvalidated(@NotNull Observable sender) {
            if (sender == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$ListBinding", "onInvalidated"));
            }
            BindingsManager.this.enqueueUpdater(this);
        }

        @Override
        public void update() {
            this.myDestList.setAll((Collection)this.mySrcExpression.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListBinding that = (ListBinding)o;
            return Objects.equal(this.myDestList, that.myDestList) && Objects.equal(this.mySrcExpression, that.mySrcExpression);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myDestList, this.mySrcExpression});
        }

        public void dispose() {
            this.mySrcExpression.removeListener(this);
        }
    }

    private class TwoWayBinding<T> {
        private final ObservableProperty<T> myPropertyLhs;
        private final ObservableProperty<T> myPropertyRhs;
        private final InvalidationListener myLeftChangedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull Observable sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$TwoWayBinding$1", "onInvalidated"));
                }
                BindingsManager.this.enqueueUpdater(new PropertyUpdater(TwoWayBinding.this.myPropertyRhs, TwoWayBinding.this.myPropertyLhs));
            }
        };
        private final InvalidationListener myRightChangedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull Observable sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$TwoWayBinding$2", "onInvalidated"));
                }
                BindingsManager.this.enqueueUpdater(new PropertyUpdater(TwoWayBinding.this.myPropertyLhs, TwoWayBinding.this.myPropertyRhs));
            }
        };

        public TwoWayBinding(ObservableProperty<T> propertyLhs, ObservableProperty<T> propertyRhs) {
            this.myPropertyLhs = propertyLhs;
            this.myPropertyRhs = propertyRhs;
            this.myPropertyLhs.addListener(this.myLeftChangedListener);
            this.myPropertyRhs.addListener(this.myRightChangedListener);
            this.myRightChangedListener.onInvalidated(propertyRhs);
        }

        public void dispose() {
            this.myPropertyLhs.removeListener(this.myLeftChangedListener);
            this.myPropertyRhs.removeListener(this.myRightChangedListener);
        }
    }

    private class OneWayBinding<T>
    extends InvalidationListener {
        private final ObservableProperty<T> myPropertyDest;
        private final ObservableValue<T> myObservableSrc;
        private final ObservableValue<Boolean> myEnabled;

        @Override
        protected void onInvalidated(@NotNull Observable sender) {
            if (sender == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$OneWayBinding", "onInvalidated"));
            }
            if (this.myEnabled.get().booleanValue()) {
                BindingsManager.this.enqueueUpdater(new PropertyUpdater<T>(this.myPropertyDest, this.myObservableSrc));
            }
        }

        public OneWayBinding(ObservableProperty<T> propertyDest, ObservableValue<T> observableSrc, ObservableValue<Boolean> enabled) {
            this.myPropertyDest = propertyDest;
            this.myObservableSrc = observableSrc;
            this.myEnabled = enabled;
            this.myObservableSrc.addListener(this);
            this.myEnabled.addListener(this);
            this.onInvalidated(observableSrc);
        }

        public void dispose() {
            this.myObservableSrc.removeListener(this);
            this.myEnabled.removeListener(this);
        }
    }

    private static interface Updater {
        public void update();
    }

    public static interface InvokeStrategy {
        public void invoke(@NotNull Runnable var1);
    }
}

