/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.updater.SdkUpdaterNoWindow;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentInstaller {
    @Nullable
    private final Multimap<PkgType, RemotePkgInfo> myRemotePackages;

    public ComponentInstaller(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        this.myRemotePackages = remotePackages;
    }

    private static Set<String> getPackageIds(Iterable<LocalPkgInfo> localPackages) {
        HashSet toUpdate = Sets.newHashSet();
        for (LocalPkgInfo localPkgInfo : localPackages) {
            toUpdate.add(localPkgInfo.getDesc().getInstallId());
        }
        return toUpdate;
    }

    private static List<LocalPkgInfo> getInstalledPackages(@NotNull SdkManager manager, @NotNull Set<String> toInstall) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/welcome/install/ComponentInstaller", "getInstalledPackages"));
        }
        if (toInstall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toInstall", "com/android/tools/idea/welcome/install/ComponentInstaller", "getInstalledPackages"));
        }
        LocalSdk localSdk = manager.getLocalSdk();
        LocalPkgInfo[] installed = localSdk.getPkgsInfos(EnumSet.allOf(PkgType.class));
        ArrayList toCheckForUpdate = Lists.newArrayListWithCapacity((int)installed.length);
        for (LocalPkgInfo info : installed) {
            if (!toInstall.contains(info.getDesc().getInstallId())) continue;
            toCheckForUpdate.add(info);
        }
        return toCheckForUpdate;
    }

    private Iterable<LocalPkgInfo> getOldPackages(Collection<LocalPkgInfo> installed) {
        if (this.myRemotePackages != null) {
            LocalPkgInfo[] packagesArray = (LocalPkgInfo[])ArrayUtil.toObjectArray(installed, LocalPkgInfo.class);
            SdkPackages packages = new SdkPackages(packagesArray, this.myRemotePackages);
            ArrayList result = Lists.newArrayList();
            for (UpdatablePkgInfo update : packages.getUpdatedPkgs()) {
                if (!update.hasRemote(false)) continue;
                result.add(update.getLocalInfo());
            }
            return result;
        }
        return installed;
    }

    private Set<String> getRequiredPackages(@NotNull Iterable<? extends InstallableComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentInstaller", "getRequiredPackages"));
        }
        HashSet packages = Sets.newHashSet();
        for (InstallableComponent installableComponent : components) {
            for (IPkgDesc pkg : installableComponent.getRequiredSdkPackages(this.myRemotePackages)) {
                if (pkg == null) continue;
                packages.add(pkg.getInstallId());
            }
        }
        return packages;
    }

    public ArrayList<String> getPackagesToInstall(@Nullable SdkManager manager, @NotNull Iterable<? extends InstallableComponent> components, boolean defaultUpdateAvailable) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentInstaller", "getPackagesToInstall"));
        }
        Set<String> toInstall = this.getRequiredPackages(components);
        if (manager == null) {
            return Lists.newArrayList(toInstall);
        }
        List<LocalPkgInfo> installed = ComponentInstaller.getInstalledPackages(manager, toInstall);
        if (!installed.isEmpty()) {
            toInstall.removeAll(ComponentInstaller.getPackageIds(installed));
            if (this.myRemotePackages != null || defaultUpdateAvailable) {
                toInstall.addAll(ComponentInstaller.getPackageIds(this.getOldPackages(installed)));
            }
        }
        return Lists.newArrayList(toInstall);
    }

    public Collection<RemotePkgInfo> getPackagesToInstallInfos(@Nullable String sdkPath, @NotNull Iterable<? extends InstallableComponent> components) {
        SdkManager sdkManager;
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentInstaller", "getPackagesToInstallInfos"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)sdkPath) && this.myRemotePackages != null && (sdkManager = SdkManager.createManager((String)sdkPath, (ILogger)new NullLogger())) != null) {
            ImmutableSet packagesToInstall = ImmutableSet.copyOf(new ComponentInstaller(this.myRemotePackages).getPackagesToInstall(sdkManager, components, true));
            HashSet remotePackages = Sets.newHashSetWithExpectedSize((int)packagesToInstall.size());
            for (RemotePkgInfo remotePkgInfo : this.myRemotePackages.values()) {
                if (!packagesToInstall.contains(remotePkgInfo.getPkgDesc().getInstallId())) continue;
                remotePackages.add(remotePkgInfo);
            }
            return remotePackages;
        }
        return ImmutableSet.of();
    }

    public void installPackages(@NotNull SdkManager manager, @NotNull ArrayList<String> packages, ILogger logger) throws WizardException {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/welcome/install/ComponentInstaller", "installPackages"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/welcome/install/ComponentInstaller", "installPackages"));
        }
        SdkUpdaterNoWindow updater = new SdkUpdaterNoWindow(manager.getLocation(), manager, logger, false, true, null, null);
        updater.updateAll(packages, true, false, null, false);
    }
}

