/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.ChooseTemplateStep;
import com.android.tools.idea.wizard.ImportWizardModuleBuilder;
import com.android.tools.idea.wizard.NewAndroidModulePath;
import com.android.tools.idea.wizard.NewModuleWizardPathFactory;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.WizardPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateWizardModuleBuilder
extends ImportWizardModuleBuilder {
    protected static final String PROJECT_NAME = "Android Project";
    protected static final String MODULE_NAME = "Android Module";
    protected static final String APP_TEMPLATE_NAME = "Android Application";
    protected static final String LIB_TEMPLATE_NAME = "Android Library";
    @Nullable
    private final String myBuilderId;
    private NewAndroidModulePath myNewAndroidModulePath;

    public TemplateWizardModuleBuilder(@Nullable File templateLocation, @Nullable TemplateMetadata metadata, @Nullable Project project, @Nullable Icon sidePanelIcon, @NotNull List<ModuleWizardStep> steps, @NotNull Disposable disposable, boolean inGlobalWizard) {
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/android/tools/idea/wizard/TemplateWizardModuleBuilder", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/TemplateWizardModuleBuilder", "<init>"));
        }
        super(templateLocation, project, null, sidePanelIcon, steps, disposable, inGlobalWizard);
        String string = this.myBuilderId = metadata == null ? null : metadata.getTitle();
        if (!inGlobalWizard) {
            this.mySteps.add(0, this.buildChooseModuleStep(project));
        }
    }

    @Override
    protected Iterable<WizardPath> setupWizardPaths(Project project, Icon sidePanelIcon, Disposable disposable) {
        ArrayList paths = Lists.newArrayList(super.setupWizardPaths(project, sidePanelIcon, disposable));
        this.myNewAndroidModulePath = new NewAndroidModulePath(this.myWizardState, this, project, sidePanelIcon, disposable);
        paths.add(this.myNewAndroidModulePath);
        for (NewModuleWizardPathFactory factory : (NewModuleWizardPathFactory[])Extensions.getExtensions(NewModuleWizardPathFactory.EP_NAME)) {
            paths.addAll(factory.createWizardPaths(this.myWizardState, this, project, sidePanelIcon, disposable));
        }
        return paths;
    }

    @Override
    protected WizardPath getDefaultPath() {
        return this.myNewAndroidModulePath;
    }

    @Override
    public void templateChanged(String templateName) {
        this.myNewAndroidModulePath.templateChanged();
        super.templateChanged(templateName);
    }

    @Nullable
    public String getBuilderId() {
        return this.myBuilderId;
    }

    private ChooseTemplateStep buildChooseModuleStep(@Nullable Project project) {
        ChooseTemplateStep chooseModuleStep = new ChooseTemplateStep(this.myWizardState, null, project, null, AndroidIcons.Wizards.NewModuleSidePanel, this, this);
        HashSet excludedTemplates = Sets.newHashSet();
        TreeSet<ChooseTemplateStep.MetadataListItem> builtinTemplateList = new TreeSet<ChooseTemplateStep.MetadataListItem>(new Comparator<ChooseTemplateStep.MetadataListItem>(){

            @Override
            public int compare(ChooseTemplateStep.MetadataListItem o1, ChooseTemplateStep.MetadataListItem o2) {
                return Collator.getInstance().compare(o1.toString(), o2.toString());
            }
        });
        for (WizardPath path : this.myPaths) {
            excludedTemplates.addAll(path.getExcludedTemplates());
            Collection<ChooseTemplateStep.MetadataListItem> templates = path.getBuiltInTemplates();
            builtinTemplateList.addAll(templates);
            for (ChooseTemplateStep.MetadataListItem template : templates) {
                this.myWizardState.associateTemplateWithPath(template.toString(), path);
            }
        }
        List<ChooseTemplateStep.MetadataListItem> templateList = ChooseTemplateStep.getTemplateList((TemplateWizardState)this.myWizardState, "gradle-projects", (Set<String>)excludedTemplates);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(builtinTemplateList.size() + templateList.size()));
        list.addAll(builtinTemplateList);
        list.addAll(templateList);
        chooseModuleStep.setListData(list);
        return chooseModuleStep;
    }
}

