/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.swing.layoutlib.GraphicsLayoutRenderer;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class AndroidPreviewPanel
extends JComponent
implements Scrollable {
    private static final Logger LOG = Logger.getInstance(AndroidPreviewPanel.class);
    private static final Notification UNSUPPORTED_LAYOUTLIB_NOTIFICATION = new Notification("Android", "Layoutlib", "The preview requires the latest version of layoutlib", NotificationType.ERROR);
    private static final AtomicBoolean ourLayoutlibNotification = new AtomicBoolean(false);
    private final DumbService myDumbService;
    private Configuration myConfiguration;
    private Document myDocument;
    private GraphicsLayoutRenderer myGraphicsLayoutRenderer;
    private double myScale;
    private Dimension myLastRenderedSize;

    public AndroidPreviewPanel(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/AndroidPreviewPanel", "<init>"));
        }
        this.myScale = 1.0;
        this.myConfiguration = configuration;
        this.myDumbService = DumbService.getInstance((Project)this.myConfiguration.getModule().getProject());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension previousSize = this.getSize();
        super.setBounds(x, y, width, height);
        Dimension currentSize = this.getSize();
        if (this.myGraphicsLayoutRenderer != null && !currentSize.equals(previousSize)) {
            this.myGraphicsLayoutRenderer.setSize(width, height);
        }
    }

    public void setScale(double scale) {
        this.myScale = scale;
        if (this.myGraphicsLayoutRenderer != null) {
            this.myGraphicsLayoutRenderer.setScale(scale);
        }
    }

    public void invalidateGraphicsRenderer() {
        if (this.myGraphicsLayoutRenderer == null) {
            return;
        }
        this.myGraphicsLayoutRenderer.dispose();
        this.myGraphicsLayoutRenderer = null;
    }

    public void updateConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/AndroidPreviewPanel", "updateConfiguration"));
        }
        this.myConfiguration = configuration;
        this.invalidateGraphicsRenderer();
    }

    public void setDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/swing/layoutlib/AndroidPreviewPanel", "setDocument"));
        }
        this.myDocument = document;
        this.invalidateGraphicsRenderer();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.myGraphicsLayoutRenderer == null && this.myDocument != null) {
            if (this.myDumbService.isDumb()) {
                this.myDumbService.runWhenSmart(new Runnable(){

                    @Override
                    public void run() {
                        AndroidPreviewPanel.this.repaint();
                    }
                });
                return;
            }
            DomPullParser parser = new DomPullParser(this.myDocument.getDocumentElement());
            try {
                this.myGraphicsLayoutRenderer = GraphicsLayoutRenderer.create(this.myConfiguration, (ILayoutPullParser)parser, false, true);
                this.myGraphicsLayoutRenderer.setScale(this.myScale);
                this.myGraphicsLayoutRenderer.setSize(this.getSize().width, this.getSize().height);
            }
            catch (UnsupportedLayoutlibException e) {
                this.notifyUnsupportedLayoutlib();
            }
            catch (InitializationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myGraphicsLayoutRenderer != null) {
            this.myGraphicsLayoutRenderer.render((Graphics2D)graphics);
            Dimension renderSize = this.myGraphicsLayoutRenderer.getPreferredSize();
            if (!renderSize.equals(this.myLastRenderedSize)) {
                this.myLastRenderedSize = renderSize;
                this.revalidate();
            }
        }
    }

    private void notifyUnsupportedLayoutlib() {
        if (ourLayoutlibNotification.compareAndSet(false, true)) {
            Notifications.Bus.notify((Notification)UNSUPPORTED_LAYOUTLIB_NOTIFICATION);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.myGraphicsLayoutRenderer == null) {
            return super.getPreferredSize();
        }
        return this.myGraphicsLayoutRenderer.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Set<String> getUsedAttrs() {
        if (this.myGraphicsLayoutRenderer == null) {
            return Collections.emptySet();
        }
        return this.myGraphicsLayoutRenderer.getUsedAttrs();
    }

    public ViewInfo findViewAtPoint(Point p) {
        return this.myGraphicsLayoutRenderer != null ? this.myGraphicsLayoutRenderer.findViewAtPoint(p) : null;
    }
}

