/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class GraphicsUtil {
    private static final int BACKGROUND_CELL_SIZE = 4;

    public static void paintCheckeredBackground(Graphics g, Color backgroundColor, Color checkeredColor, Shape clip, int cellSize) {
        Shape savedClip = g.getClip();
        ((Graphics2D)g).clip(clip);
        Rectangle rect = clip.getBounds();
        g.setColor(backgroundColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(checkeredColor);
        int dy = 0;
        while (dy * cellSize < rect.height) {
            int dx = dy % 2;
            while (dx * cellSize < rect.width) {
                g.fillRect(rect.x + dx * cellSize, rect.y + dy * cellSize, cellSize, cellSize);
                dx += 2;
            }
            ++dy;
        }
        g.setClip(savedClip);
    }

    public static void paintCheckeredBackground(Graphics g, Shape clip) {
        GraphicsUtil.paintCheckeredBackground(g, Color.LIGHT_GRAY, Color.GRAY, clip, 4);
    }

    public static void drawCross(Graphics g, Rectangle rect, float alpha) {
        Color color = g.getColor();
        g.setColor(new Color(color.getRGBComponents(null)[0], color.getRGBComponents(null)[1], color.getRGBComponents(null)[2], 0.5f));
        g.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
        g.drawLine(rect.x, rect.height, rect.x + rect.width, rect.y);
        g.setColor(color);
    }
}

