/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer;

import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.inspection.DesignerBackgroundEditorHighlighter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidDesignerEditor
extends DesignerEditor {
    private BackgroundEditorHighlighter myHighlighter;

    public AndroidDesignerEditor(Project project, VirtualFile file) {
        super(project, file);
    }

    @Nullable
    protected Module findModule(Project project, VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            module = AndroidPsiUtils.getModuleSafely(project, file);
        }
        if (module == null) {
            throw new IllegalArgumentException("No module for file " + file + " in project " + project);
        }
        return module;
    }

    @NotNull
    protected DesignerEditorPanel createDesignerPanel(Project project, Module module, VirtualFile file) {
        AndroidDesignerEditorPanel androidDesignerEditorPanel = new AndroidDesignerEditorPanel(this, project, module, file);
        if (androidDesignerEditorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerEditor", "createDesignerPanel"));
        }
        return androidDesignerEditorPanel;
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myHighlighter == null) {
            this.myHighlighter = new DesignerBackgroundEditorHighlighter(this.getDesignerPanel());
        }
        return this.myHighlighter;
    }
}

