/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.CommonBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDirectoryAction;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourceDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JTextField myNameField;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JPanel myDirectoriesPanel;
    private JBLabel myDirectoriesLabel;
    private JTextField myValueField;
    private JBLabel myValueLabel;
    private JBLabel myNameLabel;
    private JComboBox myFileNameCombo;
    private JBLabel mySourceSetLabel;
    private JComboBox mySourceSetCombo;
    private final Module myModule;
    private final ResourceType myResourceType;
    private Map<String, JCheckBox> myCheckBoxes;
    private String[] myDirNames;
    private final CheckBoxList myDirectoriesList;
    private VirtualFile myResourceDir;

    public CreateXmlResourceDialog(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable String predefinedName, @Nullable String predefinedValue, boolean chooseName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateXmlResourceDialog", "<init>"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/actions/CreateXmlResourceDialog", "<init>"));
        }
        this(module, resourceType, predefinedName, predefinedValue, chooseName, null);
    }

    public CreateXmlResourceDialog(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable String predefinedName, @Nullable String predefinedValue, boolean chooseName, @Nullable VirtualFile defaultFile) {
        String defaultFileName;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateXmlResourceDialog", "<init>"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/actions/CreateXmlResourceDialog", "<init>"));
        }
        super(module.getProject());
        this.$$$setupUI$$$();
        this.myCheckBoxes = Collections.emptyMap();
        this.myDirNames = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myResourceType = resourceType;
        if (chooseName) {
            predefinedName = ResourceHelper.prependResourcePrefix(module, predefinedName);
        }
        if (predefinedName != null && predefinedName.length() > 0) {
            if (!chooseName) {
                this.myNameLabel.setVisible(false);
                this.myNameField.setVisible(false);
            }
            this.myNameField.setText(predefinedName);
        }
        if (predefinedValue != null && predefinedValue.length() > 0) {
            this.myValueLabel.setVisible(false);
            this.myValueField.setVisible(false);
            this.myValueField.setText(predefinedValue);
        }
        HashSet modulesSet = new HashSet();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (modulesSet.size() > 0);
        if (modulesSet.size() == 1) {
            this.myModule = module;
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            this.myModule = null;
            this.myModuleCombo.setModules((Collection)modulesSet);
            this.myModuleCombo.setSelectedModule(module);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CreateResourceActionBase.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, modulesSet.size() == 1 ? AndroidFacet.getInstance((Module)modulesSet.iterator().next()) : null, this.myResourceDir != null ? PsiManager.getInstance((Project)module.getProject()).findDirectory(this.myResourceDir) : null);
        if (defaultFile == null && (defaultFileName = AndroidResourceUtil.getDefaultResourceFileName(resourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.myDirectoriesList = new CheckBoxList();
        this.myDirectoriesLabel.setLabelFor((Component)this.myDirectoriesList);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myDirectoriesList);
        decorator.setEditAction(null);
        decorator.disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CreateXmlResourceDialog.this.doAddNewDirectory();
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CreateXmlResourceDialog.this.doDeleteDirectory();
            }
        });
        AnActionButton selectAll = new AnActionButton("Select All", null, PlatformIcons.SELECT_ALL_ICON){

            public void actionPerformed(AnActionEvent e) {
                CreateXmlResourceDialog.this.doSelectAllDirs();
            }
        };
        decorator.addExtraAction(selectAll);
        AnActionButton unselectAll = new AnActionButton("Unselect All", null, PlatformIcons.UNSELECT_ALL_ICON){

            public void actionPerformed(AnActionEvent e) {
                CreateXmlResourceDialog.this.doUnselectAllDirs();
            }
        };
        decorator.addExtraAction(unselectAll);
        this.myDirectoriesPanel.add(decorator.createPanel());
        this.updateDirectories(true);
        this.myModuleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateXmlResourceDialog.this.updateDirectories(true);
            }
        });
        JCheckBox valuesCheckBox = this.myCheckBoxes.get("values");
        if (valuesCheckBox != null) {
            valuesCheckBox.setSelected(true);
        }
        if (defaultFile != null) {
            this.resetFromFile(defaultFile, module.getProject());
        }
        this.init();
    }

    private void resetFromFile(@NotNull VirtualFile file, @NotNull Project project) {
        JCheckBox checkBox;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/actions/CreateXmlResourceDialog", "resetFromFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateXmlResourceDialog", "resetFromFile"));
        }
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (moduleForFile == null) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myModule == null) {
            Module prev = this.myModuleCombo.getSelectedModule();
            this.myModuleCombo.setSelectedItem((Object)moduleForFile);
            if (!moduleForFile.equals(this.myModuleCombo.getSelectedItem())) {
                this.myModuleCombo.setSelectedModule(prev);
                return;
            }
        } else if (!this.myModule.equals(moduleForFile)) {
            return;
        }
        if ((checkBox = this.myCheckBoxes.get(parent.getName())) == null) {
            return;
        }
        for (JCheckBox checkBox1 : this.myCheckBoxes.values()) {
            checkBox1.setSelected(false);
        }
        checkBox.setSelected(true);
        this.myFileNameCombo.getEditor().setItem(file.getName());
    }

    private void doDeleteDirectory() {
        if (this.myResourceDir == null) {
            return;
        }
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        String selectedDirName = this.myDirNames[selectedIndex];
        final VirtualFile selectedDir = this.myResourceDir.findChild(selectedDirName);
        if (selectedDir == null) {
            return;
        }
        VirtualFileDeleteProvider provider = new VirtualFileDeleteProvider();
        provider.deleteElement(new DataContext(){

            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.VIRTUAL_FILE_ARRAY.getName().equals(dataId)) {
                    return new VirtualFile[]{selectedDir};
                }
                return null;
            }
        });
        this.updateDirectories(false);
    }

    private void doSelectAllDirs() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(true);
        }
        this.myDirectoriesList.repaint();
    }

    private void doUnselectAllDirs() {
        for (JCheckBox checkBox : this.myCheckBoxes.values()) {
            checkBox.setSelected(false);
        }
        this.myDirectoriesList.repaint();
    }

    private void doAddNewDirectory() {
        PsiElement[] createdElements;
        if (this.myResourceDir == null) {
            return;
        }
        Module module = this.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        PsiDirectory psiResDir = PsiManager.getInstance((Project)project).findDirectory(this.myResourceDir);
        if (psiResDir != null && (createdElements = new CreateResourceDirectoryAction(ResourceFolderType.VALUES).invokeDialog(project, psiResDir)).length > 0) {
            this.updateDirectories(false);
        }
    }

    private void updateDirectories(boolean updateFileCombo) {
        AndroidFacet facet;
        Module module = this.getModule();
        List<Object> valuesDirs = Collections.emptyList();
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            this.myResourceDir = facet.getPrimaryResourceDir();
            if (this.myResourceDir != null) {
                valuesDirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.VALUES.getName(), new VirtualFile[]{this.myResourceDir});
            }
        }
        Collections.sort(valuesDirs, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile f1, VirtualFile f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        Map<String, JCheckBox> oldCheckBoxes = this.myCheckBoxes;
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        String selectedDirName = selectedIndex >= 0 ? this.myDirNames[selectedIndex] : null;
        ArrayList<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
        this.myCheckBoxes = new HashMap();
        this.myDirNames = new String[valuesDirs.size()];
        int newSelectedIndex = -1;
        int i = 0;
        for (VirtualFile virtualFile : valuesDirs) {
            String dirName = virtualFile.getName();
            JCheckBox jCheckBox = oldCheckBoxes.get(dirName);
            boolean selected = jCheckBox != null && jCheckBox.isSelected();
            JCheckBox checkBox = new JCheckBox(dirName, selected);
            checkBoxList.add(checkBox);
            this.myCheckBoxes.put(dirName, checkBox);
            this.myDirNames[i] = dirName;
            if (dirName.equals(selectedDirName)) {
                newSelectedIndex = i;
            }
            ++i;
        }
        this.myDirectoriesList.setModel((ListModel)new CollectionListModel(checkBoxList));
        if (newSelectedIndex >= 0) {
            this.myDirectoriesList.setSelectedIndex(newSelectedIndex);
        }
        if (checkBoxList.size() == 1) {
            ((JCheckBox)checkBoxList.get(0)).setSelected(true);
        }
        if (updateFileCombo) {
            Object oldItem = this.myFileNameCombo.getEditor().getItem();
            HashSet hashSet = new HashSet();
            for (VirtualFile virtualFile : valuesDirs) {
                for (VirtualFile file : virtualFile.getChildren()) {
                    hashSet.add(file.getName());
                }
            }
            ArrayList fileNames = new ArrayList(hashSet);
            Collections.sort(fileNames);
            this.myFileNameCombo.setModel(new DefaultComboBoxModel<Object>(fileNames.toArray()));
            this.myFileNameCombo.getEditor().setItem(oldItem);
        }
    }

    protected ValidationInfo doValidate() {
        String resourceName = this.getResourceName();
        Module selectedModule = this.getModule();
        List<String> directoryNames = this.getDirNames();
        String fileName = this.getFileName();
        if (resourceName.length() == 0) {
            return new ValidationInfo("specify resource name", (JComponent)this.myNameField);
        }
        if (!AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            return new ValidationInfo(resourceName + " is not correct resource name", (JComponent)this.myNameField);
        }
        if (fileName.length() == 0) {
            return new ValidationInfo("specify file name", (JComponent)this.myFileNameCombo);
        }
        if (selectedModule == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        if (directoryNames.size() == 0) {
            return new ValidationInfo("choose directories", (JComponent)this.myDirectoriesList);
        }
        if (resourceName.equals(ResourceHelper.prependResourcePrefix(this.myModule, null))) {
            return new ValidationInfo("specify more than resource prefix", (JComponent)this.myNameField);
        }
        ValidationInfo info = CreateXmlResourceDialog.checkIfResourceAlreadyExists(selectedModule, resourceName, this.myResourceType, directoryNames, fileName);
        if (info != null) {
            return info;
        }
        return null;
    }

    @Nullable
    public static ValidationInfo checkIfResourceAlreadyExists(@NotNull Module selectedModule, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull List<String> dirNames, @NotNull String fileName) {
        VirtualFile resourceDir;
        if (selectedModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModule", "org/jetbrains/android/actions/CreateXmlResourceDialog", "checkIfResourceAlreadyExists"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/actions/CreateXmlResourceDialog", "checkIfResourceAlreadyExists"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/actions/CreateXmlResourceDialog", "checkIfResourceAlreadyExists"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/actions/CreateXmlResourceDialog", "checkIfResourceAlreadyExists"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/actions/CreateXmlResourceDialog", "checkIfResourceAlreadyExists"));
        }
        if (resourceName.length() == 0 || dirNames.size() == 0 || fileName.length() == 0) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(selectedModule);
        VirtualFile virtualFile = resourceDir = facet != null ? facet.getPrimaryResourceDir() : null;
        if (resourceDir == null) {
            return null;
        }
        for (String directoryName : dirNames) {
            VirtualFile resFile;
            VirtualFile resourceSubdir = resourceDir.findChild(directoryName);
            if (resourceSubdir == null || (resFile = resourceSubdir.findChild(fileName)) == null) continue;
            if (resFile.getFileType() != StdFileTypes.XML) {
                return new ValidationInfo("File " + FileUtil.toSystemDependentName((String)resFile.getPath()) + " is not XML file");
            }
            Resources resources = AndroidUtils.loadDomElement(selectedModule, resFile, Resources.class);
            if (resources == null) {
                return new ValidationInfo(AndroidBundle.message("not.resource.file.error", FileUtil.toSystemDependentName((String)resFile.getPath())));
            }
            for (ResourceElement element : AndroidResourceUtil.getValueResourcesFromElement(resourceType.getName(), resources)) {
                if (!resourceName.equals(element.getName().getValue())) continue;
                return new ValidationInfo("resource '" + resourceName + "' already exists in " + FileUtil.toSystemDependentName((String)resFile.getPath()));
            }
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        String name = this.myNameField.getText();
        if (name.length() == 0 || name.equals(ResourceHelper.prependResourcePrefix(this.myModule, null))) {
            return this.myNameField;
        }
        if (this.myValueField.isVisible()) {
            return this.myValueField;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        return this.myFileNameCombo;
    }

    protected void doOKAction() {
        String resourceName = this.getResourceName();
        String fileName = this.getFileName();
        List<String> dirNames = this.getDirNames();
        Module module = this.getModule();
        if (resourceName.length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"Resource name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (!AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            Messages.showErrorDialog((Component)this.myPanel, (String)(resourceName + " is not correct resource name"), (String)CommonBundle.getErrorTitle());
        } else if (fileName.length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"File name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (dirNames.size() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"Directories are not selected", (String)CommonBundle.getErrorTitle());
        } else if (module == null) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"Module is not specified", (String)CommonBundle.getErrorTitle());
        } else {
            super.doOKAction();
        }
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateXmlResourceDialog";
    }

    @NotNull
    public String getResourceName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourceDialog", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public List<String> getDirNames() {
        ArrayList<String> selectedDirs = new ArrayList<String>();
        for (Map.Entry<String, JCheckBox> entry : this.myCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            selectedDirs.add(entry.getKey());
        }
        ArrayList<String> arrayList = selectedDirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourceDialog", "getDirNames"));
        }
        return arrayList;
    }

    @NotNull
    public String getFileName() {
        String string = ((String)this.myFileNameCombo.getEditor().getItem()).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourceDialog", "getFileName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourceDialog", "getName"));
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.myValueField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateXmlResourceDialog", "getValue"));
        }
        return string;
    }

    @Nullable
    public SourceProvider getSourceProvider() {
        return CreateResourceActionBase.getSourceProvider(this.mySourceSetCombo);
    }

    @Nullable
    public Module getModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JTextField jTextField;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JBLabel jBLabel4;
        ModulesComboBox modulesComboBox;
        JTextField jTextField2;
        JBLabel jBLabel5;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(800, 600));
        this.myNameLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Resource name:");
        jBLabel5.setDisplayedMnemonic('N');
        jBLabel5.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Module:");
        jBLabel4.setDisplayedMnemonic('M');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("File name:");
        jBLabel6.setDisplayedMnemonic('F');
        jBLabel6.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoriesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoriesLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Create the resource in directories:");
        jBLabel3.setDisplayedMnemonic('C');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myValueLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource value:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValueField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFileNameCombo = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel5.setLabelFor(jTextField2);
        jBLabel4.setLabelFor((Component)modulesComboBox);
        jBLabel2.setLabelFor(jTextField);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

