/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.SdkConstants;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.awt.Component;
import java.io.File;
import org.jetbrains.android.actions.AndroidRunSdkToolAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.StringBuildingOutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAndroidSdkManagerAction
extends AndroidRunSdkToolAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.RunAndroidSdkManagerAction");

    public static void updateInWelcomePage(@Nullable Component component) {
        ActionManager actionManager;
        AnAction sdkManagerAction;
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectManager.getInstance().getOpenProjects().length == 0 && (sdkManagerAction = (actionManager = ActionManager.getInstance()).getAction("WelcomeScreen.RunAndroidSdkManager")) instanceof RunAndroidSdkManagerAction) {
            Presentation presentation = sdkManagerAction.getTemplatePresentation();
            IdeFrame frame = WelcomeFrame.getInstance();
            if (frame == null) {
                return;
            }
            Component c = component != null ? component : frame.getComponent();
            DataContext dataContext = DataManager.getInstance().getDataContext(c);
            AnActionEvent event = new AnActionEvent(null, dataContext, "WelcomeScreen", presentation, actionManager, 0);
            sdkManagerAction.update(event);
        }
    }

    public RunAndroidSdkManagerAction() {
        super(RunAndroidSdkManagerAction.getName());
    }

    private static String getName() {
        return AndroidBundle.message("android.run.sdk.manager.action.text", new Object[0]);
    }

    @Override
    public void update(AnActionEvent e) {
        if ("WelcomeScreen".equals(e.getPlace())) {
            e.getPresentation().setEnabled(AndroidSdkUtils.isAndroidSdkAvailable());
            return;
        }
        super.update(e);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        if ("WelcomeScreen".equals(e.getPlace())) {
            AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (sdkData != null) {
                this.doRunTool(null, sdkData.getLocation().getPath());
            }
        } else {
            super.actionPerformed(e);
        }
    }

    public static void runSpecificSdkManager(@Nullable Project project, @NotNull File sdkHome) {
        if (sdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHome", "org/jetbrains/android/actions/RunAndroidSdkManagerAction", "runSpecificSdkManager"));
        }
        new RunAndroidSdkManagerAction().doRunTool(project, sdkHome.getPath());
    }

    public static void runSpecificSdkManagerSynchronously(@Nullable Project project, @NotNull File sdkHome) {
        if (sdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHome", "org/jetbrains/android/actions/RunAndroidSdkManagerAction", "runSpecificSdkManagerSynchronously"));
        }
        new SdkManagerRunner(sdkHome.getPath(), null, project).run();
    }

    @Override
    protected void doRunTool(final @Nullable Project project, final @NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/actions/RunAndroidSdkManagerAction", "doRunTool"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                RunAndroidSdkManagerAction.launchExternalSdkManager(project, sdkPath);
            }
        });
    }

    private static void launchExternalSdkManager(@Nullable Project project, @NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/actions/RunAndroidSdkManagerAction", "launchExternalSdkManager"));
        }
        ProgressWindow p = new ProgressWindow(false, true, project);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new SdkManagerRunner(sdkPath, p, project));
    }

    private static class SdkManagerRunner
    implements Runnable {
        private final String mySdkPath;
        private final ProgressWindow myProgressWindow;
        private final Project myProject;

        private SdkManagerRunner(String sdkPath, ProgressWindow progressWindow, Project project) {
            this.mySdkPath = sdkPath;
            this.myProgressWindow = progressWindow;
            this.myProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuildingOutputProcessor processor;
            block10: {
                UsageTracker.getInstance().trackEvent("sdkManager", "standaloneLaunched", null, null);
                String toolPath = this.mySdkPath + File.separator + AndroidCommonUtils.toolPath((String)SdkConstants.androidCmdName());
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(toolPath);
                commandLine.addParameter("sdk");
                processor = new StringBuildingOutputProcessor();
                try {
                    if (AndroidUtils.executeCommand(commandLine, processor, WaitingStrategies.WaitForTime.getInstance(500)) != ExecutionStatus.TIMEOUT) break block10;
                    if (this.myProgressWindow != null) {
                        try {
                            this.myProgressWindow.start();
                            this.myProgressWindow.setText("Starting SDK Manager...");
                            for (double d = 0.0; d < 1.0; d += 0.05) {
                                this.myProgressWindow.setFraction(d);
                                Thread.sleep(100L);
                            }
                        }
                        catch (InterruptedException d) {
                        }
                        finally {
                            this.myProgressWindow.stop();
                        }
                    }
                    return;
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                    return;
                }
            }
            final String message = processor.getMessage();
            if (message.toLowerCase().contains("error")) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)SdkManagerRunner.this.myProject, (String)("Cannot launch SDK manager.\nOutput:\n" + message), (String)RunAndroidSdkManagerAction.getName());
                    }
                });
            }
        }
    }
}

