/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import org.jetbrains.android.inspections.lint.DomPsiConverter;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DomPsiParser
extends XmlParser {
    private final LintClient myClient;
    private AccessToken myReadLock;

    public DomPsiParser(LintClient client) {
        this.myClient = client;
    }

    public void dispose(@NonNull XmlContext context, @NonNull Document document) {
        if (context.document != null) {
            this.myReadLock.finish();
            this.myReadLock = null;
            context.document = null;
        }
    }

    public int getNodeStartOffset(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        return textRange.getStartOffset();
    }

    public int getNodeEndOffset(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        return textRange.getEndOffset();
    }

    @Nullable
    public Document parseXml(@NonNull XmlContext context) {
        assert (this.myReadLock == null);
        this.myReadLock = ApplicationManager.getApplication().acquireReadActionLock();
        Document document = this.parse(context);
        if (document == null) {
            this.myReadLock.finish();
            this.myReadLock = null;
        }
        return document;
    }

    @Nullable
    private Document parse(XmlContext context) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        try {
            return DomPsiConverter.convert(xmlFile);
        }
        catch (Throwable t) {
            this.myClient.log(t, "Failed converting PSI parse tree to DOM for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    @NonNull
    public Location getLocation(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    @NonNull
    public Location getLocation(@NonNull XmlContext context, @NonNull Node node, int startDelta, int endDelta) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset() + startDelta);
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getStartOffset() + endDelta);
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    @NonNull
    public Location getNameLocation(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextNameRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    @NonNull
    public Location getValueLocation(@NonNull XmlContext context, @NonNull Attr node) {
        TextRange textRange = DomPsiConverter.getTextValueRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull XmlContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    private static class LocationHandle
    implements Location.Handle {
        private final File myFile;
        private final Node myNode;
        private Object myClientData;

        public LocationHandle(File file, Node node) {
            this.myFile = file;
            this.myNode = node;
        }

        @NonNull
        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Location>(){

                    public Location compute() {
                        return LocationHandle.this.resolve();
                    }
                });
            }
            TextRange textRange = DomPsiConverter.getTextRange(this.myNode);
            DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start, (Position)end);
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }
}

