/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.logcat.AndroidLogcatFormatter;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatReceiver
extends AndroidOutputReceiver {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.logcat.AndroidLogcatReceiver");
    private static Pattern LOG_PATTERN = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\S+)\\s([VDIWEAF])/(.*)\\]$", 32);
    public static final String CONTINUATION_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    public static final String STACK_TRACE_LINE_PREFIX = CONTINUATION_LINE_PREFIX + StringUtil.repeatSymbol((char)' ', (int)8);
    public static final String EXPANDED_STACK_TRACE_LINE_PREFIX = STACK_TRACE_LINE_PREFIX.replace(' ', '\u00a0');
    public static final String STACK_TRACE_CAUSE_LINE_PREFIX = CONTINUATION_LINE_PREFIX + Character.toString(' ');
    private LogMessageHeader myLastMessageHeader;
    private volatile boolean myCanceled = false;
    private Log.LogLevel myPrevLogLevel;
    private final Writer myWriter;
    private final IDevice myDevice;
    private final StackTraceExpander myStackTraceExpander = new StackTraceExpander(CONTINUATION_LINE_PREFIX, STACK_TRACE_LINE_PREFIX, EXPANDED_STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX);

    public AndroidLogcatReceiver(IDevice device, Writer writer) {
        this.myDevice = device;
        this.myWriter = new PrintWriter(writer);
    }

    @Override
    public void processNewLine(String line) {
        Matcher matcher = LOG_PATTERN.matcher(line);
        if (this.myLastMessageHeader == null && matcher.matches()) {
            long tidValue;
            this.myLastMessageHeader = new LogMessageHeader();
            this.myLastMessageHeader.myTime = matcher.group(1);
            this.myLastMessageHeader.myPid = Integer.valueOf(matcher.group(2));
            String tid = matcher.group(3).trim();
            try {
                tidValue = Long.decode(tid.trim());
            }
            catch (NumberFormatException e) {
                tidValue = -1L;
            }
            this.myLastMessageHeader.myTid = Long.toString(tidValue);
            this.myLastMessageHeader.myAppPackage = this.myDevice == null ? "" : this.myDevice.getClientName(this.myLastMessageHeader.myPid);
            this.myLastMessageHeader.myLogLevel = AndroidLogcatReceiver.getByLetterString(matcher.group(4));
            this.myLastMessageHeader.myTag = matcher.group(5).trim();
        } else {
            if (line.length() == 0) {
                return;
            }
            String text = this.myLastMessageHeader == null ? this.myStackTraceExpander.expand(line) : AndroidLogcatReceiver.getFullMessage(line, this.myLastMessageHeader);
            try {
                this.myWriter.write(text + '\n');
            }
            catch (IOException ignored) {
                LOG.info((Throwable)ignored);
            }
            this.myLastMessageHeader = null;
        }
    }

    @Nullable
    private static Log.LogLevel getByLetterString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        Log.LogLevel logLevel = Log.LogLevel.getByLetterString((String)s);
        if (logLevel == null && s.equals("F")) {
            return Log.LogLevel.ASSERT;
        }
        return logLevel;
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    private static String getFullMessage(String message, LogMessageHeader header) {
        return AndroidLogcatFormatter.formatMessage(message, header);
    }

    public void cancel() {
        this.myCanceled = true;
    }

    static class LogMessageHeader {
        String myTime;
        Log.LogLevel myLogLevel;
        int myPid;
        String myTid;
        String myAppPackage;
        String myTag;

        LogMessageHeader() {
        }
    }
}

