/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ddmlib.MultiLineReceiver;
import com.intellij.openapi.diagnostic.Logger;
import java.io.UnsupportedEncodingException;

public abstract class AndroidOutputReceiver
extends MultiLineReceiver {
    private static final String BAD_ACCESS_ERROR = "Bad address (14)";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidOutputReceiver");
    private boolean myTryAgain;

    public void processNewLines(String[] lines) {
        if (!this.myTryAgain) {
            for (String line : lines) {
                this.processNewLine(line);
                if (line.indexOf(BAD_ACCESS_ERROR) < 0) continue;
                this.myTryAgain = true;
                break;
            }
        }
    }

    public boolean isTryAgain() {
        return this.myTryAgain;
    }

    public void invalidate() {
        this.myTryAgain = false;
    }

    protected abstract void processNewLine(String var1);

    private static String decodeIso8859_1(String text) {
        try {
            return new String(text.getBytes("ISO8859_1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error while fix encoding", (Throwable)e);
            return text;
        }
    }
}

