/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.DataMap;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.DuplicateDataException;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class DataMerger<I extends DataItem<F>, F extends DataFile<I>, S extends DataSet<I, F>>
implements DataMap<I> {
    static final String FN_MERGER_XML = "merger.xml";
    static final String NODE_MERGER = "merger";
    static final String NODE_DATA_SET = "dataSet";
    static final String NODE_CONFIGURATION = "configuration";
    static final String ATTR_VERSION = "version";
    static final String MERGE_BLOB_VERSION = "3";
    @NonNull
    protected final DocumentBuilderFactory mFactory;
    private final List<S> mDataSets = Lists.newArrayList();

    public DataMerger() {
        this.mFactory = DocumentBuilderFactory.newInstance();
        this.mFactory.setNamespaceAware(true);
        this.mFactory.setValidating(false);
        this.mFactory.setIgnoringComments(true);
    }

    protected abstract S createFromXml(Node var1) throws MergingException;

    protected abstract boolean requiresMerge(@NonNull String var1);

    protected abstract void mergeItems(@NonNull String var1, @NonNull List<I> var2, @NonNull MergeConsumer<I> var3) throws MergingException;

    public void addDataSet(S resourceSet) {
        this.mDataSets.add(resourceSet);
    }

    @NonNull
    public List<S> getDataSets() {
        return this.mDataSets;
    }

    void validateDataSets() throws DuplicateDataException {
        for (DataSet resourceSet : this.mDataSets) {
            resourceSet.checkItems();
        }
    }

    @Override
    public int size() {
        HashSet keys = Sets.newHashSet();
        for (DataSet resourceSet : this.mDataSets) {
            ListMultimap map = resourceSet.getDataMap();
            keys.addAll(map.keySet());
        }
        return keys.size();
    }

    @Override
    @NonNull
    public ListMultimap<String, I> getDataMap() {
        ArrayListMultimap fullItemMultimap = ArrayListMultimap.create();
        for (DataSet resourceSet : this.mDataSets) {
            ListMultimap map = resourceSet.getDataMap();
            for (Map.Entry entry : map.asMap().entrySet()) {
                fullItemMultimap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return fullItemMultimap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeData(@NonNull MergeConsumer<I> consumer, boolean doCleanUp) throws MergingException {
        consumer.start(this.mFactory);
        try {
            HashSet dataItemKeys = Sets.newHashSet();
            for (DataSet dataSet : this.mDataSets) {
                dataSet.checkItems();
                ListMultimap map = dataSet.getDataMap();
                dataItemKeys.addAll(map.keySet());
            }
            for (String dataItemKey : dataItemKeys) {
                if (this.requiresMerge(dataItemKey)) {
                    ArrayList items = Lists.newArrayListWithExpectedSize((int)this.mDataSets.size());
                    for (DataSet dataSet : this.mDataSets) {
                        ListMultimap itemMap = dataSet.getDataMap();
                        List setItems = itemMap.get((Object)dataItemKey);
                        items.addAll(setItems);
                    }
                    this.mergeItems(dataItemKey, items, consumer);
                    continue;
                }
                DataItem previouslyWritten = null;
                DataItem toWrite = null;
                boolean foundIgnoredItem = false;
                block6: for (int i = this.mDataSets.size() - 1; i >= 0; --i) {
                    DataSet dataSet = (DataSet)this.mDataSets.get(i);
                    ListMultimap itemMap = dataSet.getDataMap();
                    List items = itemMap.get((Object)dataItemKey);
                    if (items.isEmpty()) continue;
                    for (int ii = items.size() - 1; ii >= 0; --ii) {
                        DataItem item = (DataItem)items.get(ii);
                        if (consumer.ignoreItemInMerge(item)) {
                            foundIgnoredItem = true;
                            continue;
                        }
                        if (item.isWritten()) {
                            assert (previouslyWritten == null);
                            previouslyWritten = item;
                        }
                        if (toWrite == null && !item.isRemoved()) {
                            toWrite = item;
                        }
                        if (toWrite != null && previouslyWritten != null) break block6;
                    }
                }
                assert (foundIgnoredItem || previouslyWritten != null || toWrite != null);
                if (previouslyWritten == null && toWrite == null) continue;
                if (toWrite == null) {
                    assert (previouslyWritten.isRemoved());
                    consumer.removeItem(previouslyWritten, null);
                    continue;
                }
                if (previouslyWritten == null || previouslyWritten == toWrite) {
                    consumer.addItem(toWrite);
                    continue;
                }
                toWrite.setTouched();
                consumer.addItem(toWrite);
                consumer.removeItem(previouslyWritten, toWrite);
            }
        }
        finally {
            consumer.end();
        }
        if (doCleanUp) {
            this.postMergeCleanUp();
        }
    }

    public void writeBlobTo(@NonNull File blobRootFolder, @NonNull MergeConsumer<I> consumer) throws MergingException {
        try {
            DocumentBuilder builder = this.mFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootNode = document.createElement(NODE_MERGER);
            NodeUtils.addAttribute(document, rootNode, null, ATTR_VERSION, MERGE_BLOB_VERSION);
            document.appendChild(rootNode);
            for (DataSet dataSet : this.mDataSets) {
                Element dataSetNode = document.createElement(NODE_DATA_SET);
                rootNode.appendChild(dataSetNode);
                dataSet.appendToXml(dataSetNode, document, consumer);
            }
            this.writeAdditionalData(document, rootNode);
            String content = XmlUtils.toXml((Node)document, (boolean)true);
            try {
                this.createDir(blobRootFolder);
            }
            catch (IOException ioe) {
                throw MergingException.wrapException(ioe).withFile(blobRootFolder).build();
            }
            File file = new File(blobRootFolder, FN_MERGER_XML);
            try {
                Files.write((CharSequence)content, (File)file, (Charset)Charsets.UTF_8);
            }
            catch (IOException ioe) {
                throw MergingException.wrapException(ioe).withFile(file).build();
            }
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).build();
        }
    }

    public boolean loadFromBlob(@NonNull File blobRootFolder, boolean incrementalState) throws MergingException {
        File file = new File(blobRootFolder, FN_MERGER_XML);
        if (!file.isFile()) {
            return false;
        }
        try {
            Document document = XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
            Element rootNode = document.getDocumentElement();
            if (rootNode == null || !NODE_MERGER.equals(rootNode.getLocalName())) {
                return false;
            }
            String version = null;
            Attr versionAttr = (Attr)rootNode.getAttributes().getNamedItem(ATTR_VERSION);
            if (versionAttr != null) {
                version = versionAttr.getValue();
            }
            if (!MERGE_BLOB_VERSION.equals(version)) {
                return false;
            }
            NodeList nodes = rootNode.getChildNodes();
            int n = nodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                if (NODE_DATA_SET.equals(node.getLocalName())) {
                    S dataSet = this.createFromXml(node);
                    if (dataSet == null) continue;
                    this.addDataSet(dataSet);
                    continue;
                }
                if (!incrementalState || !this.getAdditionalDataTagName().equals(node.getLocalName())) continue;
                this.loadAdditionalData(node, incrementalState);
            }
            if (incrementalState) {
                this.setPostBlobLoadStateToWritten();
            } else {
                this.setPostBlobLoadStateToTouched();
            }
            return true;
        }
        catch (SAXParseException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (IOException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (SAXException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
    }

    @NonNull
    protected String getAdditionalDataTagName() {
        return "";
    }

    protected void loadAdditionalData(@NonNull Node additionalDataNode, boolean incrementalState) throws MergingException {
    }

    protected void writeAdditionalData(Document document, Node rootNode) throws MergingException {
    }

    public void cleanBlob(@NonNull File blobRootFolder) {
        File file = new File(blobRootFolder, FN_MERGER_XML);
        if (file.isFile()) {
            file.delete();
        }
    }

    private void setPostBlobLoadStateToWritten() {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        for (DataSet dataSet : this.mDataSets) {
            ListMultimap map = dataSet.getDataMap();
            for (Map.Entry entry : map.asMap().entrySet()) {
                itemMap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        for (String key : itemMap.keySet()) {
            List itemList = itemMap.get((Object)key);
            ((DataItem)itemList.get(itemList.size() - 1)).resetStatusToWritten();
        }
    }

    private void setPostBlobLoadStateToTouched() {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        for (DataSet dataSet : this.mDataSets) {
            ListMultimap map = dataSet.getDataMap();
            for (Map.Entry entry : map.asMap().entrySet()) {
                itemMap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        for (String key : itemMap.keySet()) {
            List itemList = itemMap.get((Object)key);
            ((DataItem)itemList.get(itemList.size() - 1)).resetStatusToTouched();
        }
    }

    private void postMergeCleanUp() {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        for (DataSet dataSet : this.mDataSets) {
            ListMultimap map = dataSet.getDataMap();
            ArrayList keys = Lists.newArrayList((Iterable)map.keySet());
            for (String key : keys) {
                List list = map.get((Object)key);
                int i = 0;
                while (i < list.size()) {
                    DataItem item = (DataItem)list.get(i);
                    if (item.isRemoved()) {
                        list.remove(i);
                        continue;
                    }
                    itemMap.put((Object)key, (Object)item.resetStatus());
                    ++i;
                }
            }
        }
        for (String key : itemMap.keySet()) {
            List itemList = itemMap.get((Object)key);
            ((DataItem)itemList.get(itemList.size() - 1)).resetStatusToWritten();
        }
    }

    public boolean checkValidUpdate(List<S> dataSets) {
        if (dataSets.size() != this.mDataSets.size()) {
            return false;
        }
        int n = dataSets.size();
        for (int i = 0; i < n; ++i) {
            DataSet localSet = (DataSet)this.mDataSets.get(i);
            DataSet newSet = (DataSet)dataSets.get(i);
            ArrayList localSourceFiles = localSet.getSourceFiles();
            ArrayList newSourceFiles = newSet.getSourceFiles();
            if (!newSet.getConfigName().equals(localSet.getConfigName()) || localSourceFiles.size() != newSourceFiles.size()) {
                return false;
            }
            localSourceFiles = Lists.newArrayList(localSourceFiles);
            Collections.sort(localSourceFiles);
            newSourceFiles = Lists.newArrayList(newSourceFiles);
            Collections.sort(newSourceFiles);
            if (localSourceFiles.equals(newSourceFiles)) continue;
            return false;
        }
        return true;
    }

    public FileValidity<S> findDataSetContaining(@NonNull File file) {
        return this.findDataSetContaining(file, null);
    }

    public FileValidity<S> findDataSetContaining(@NonNull File file, @Nullable FileValidity<S> fileValidity) {
        if (fileValidity == null) {
            fileValidity = new FileValidity();
        }
        if (this.mDataSets.isEmpty()) {
            fileValidity.status = FileValidity.FileStatus.UNKNOWN_FILE;
            return fileValidity;
        }
        if (DataSet.isIgnored(file)) {
            fileValidity.status = FileValidity.FileStatus.IGNORED_FILE;
            return fileValidity;
        }
        for (DataSet dataSet : this.mDataSets) {
            File sourceFile = dataSet.findMatchingSourceFile(file);
            if (sourceFile == null) continue;
            fileValidity.dataSet = dataSet;
            fileValidity.sourceFile = sourceFile;
            fileValidity.status = dataSet.isValidSourceFile(sourceFile, file) ? FileValidity.FileStatus.VALID_FILE : FileValidity.FileStatus.IGNORED_FILE;
            return fileValidity;
        }
        fileValidity.status = FileValidity.FileStatus.UNKNOWN_FILE;
        return fileValidity;
    }

    protected synchronized void createDir(File folder) throws IOException {
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("Failed to create directory: " + folder);
        }
    }

    public String toString() {
        return Arrays.toString(this.mDataSets.toArray());
    }
}

