/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ScanningContext;
import com.android.ide.common.resources.ValueResourceParser;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class MultiResourceFile
extends ResourceFile
implements ValueResourceParser.IValueResourceRepository {
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private final Map<ResourceType, Map<String, ResourceValue>> mResourceItems = new EnumMap<ResourceType, Map<String, ResourceValue>>(ResourceType.class);
    private Collection<ResourceType> mResourceTypeList = null;
    private boolean mNeedIdRefresh;

    public MultiResourceFile(IAbstractFile file, ResourceFolder folder) {
        super(file, folder);
    }

    @Override
    protected void load(ScanningContext context) {
        this.parseFile();
        this.mResourceTypeList = Collections.unmodifiableCollection(this.mResourceItems.keySet());
        this.mNeedIdRefresh = true;
        this.updateResourceItems(context);
    }

    @Override
    protected void update(ScanningContext context) {
        this.mNeedIdRefresh = false;
        EnumMap<ResourceType, Map<String, ResourceValue>> oldResourceItems = new EnumMap<ResourceType, Map<String, ResourceValue>>(this.mResourceItems);
        this.mResourceItems.clear();
        this.parseFile();
        this.mResourceTypeList = Collections.unmodifiableCollection(this.mResourceItems.keySet());
        if (oldResourceItems.keySet().equals(this.mResourceItems.keySet())) {
            for (ResourceType type : this.mResourceTypeList) {
                if (this.mResourceItems.get(type).keySet().equals(((Map)oldResourceItems.get(type)).keySet())) continue;
                this.mNeedIdRefresh = true;
            }
        } else {
            this.mNeedIdRefresh = true;
        }
        this.updateResourceItems(context);
    }

    @Override
    protected void dispose(ScanningContext context) {
        ResourceRepository repository = this.getRepository();
        repository.removeFile(this.mResourceTypeList, (ResourceFile)this);
        context.requestFullAapt();
    }

    @Override
    public Collection<ResourceType> getResourceTypes() {
        return this.mResourceTypeList;
    }

    @Override
    public boolean hasResources(ResourceType type) {
        Map<String, ResourceValue> list = this.mResourceItems.get(type);
        return list != null && list.size() > 0;
    }

    private void updateResourceItems(ScanningContext context) {
        ResourceRepository repository = this.getRepository();
        repository.removeFile(this.mResourceTypeList, (ResourceFile)this);
        for (ResourceType type : this.mResourceTypeList) {
            Map<String, ResourceValue> list = this.mResourceItems.get(type);
            if (list == null) continue;
            Collection<ResourceValue> values = list.values();
            for (ResourceValue res : values) {
                ResourceItem item = repository.getResourceItem(type, res.getName());
                item.add(this);
            }
        }
        if (this.mNeedIdRefresh) {
            context.requestFullAapt();
        }
    }

    private void parseFile() {
        try {
            SAXParser parser = sParserFactory.newSAXParser();
            parser.parse(this.getFile().getContents(), (DefaultHandler)new ValueResourceParser(this, this.isFramework()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (StreamException streamException) {
            // empty catch block
        }
    }

    @Override
    public void addResourceValue(ResourceValue value) {
        ResourceType resType = value.getResourceType();
        Map<String, ResourceValue> list = this.mResourceItems.get(resType);
        if (list == null) {
            list = new HashMap<String, ResourceValue>();
            this.mResourceItems.put(resType, list);
        } else {
            ResourceValue oldValue = list.get(value.getName());
            if (oldValue != null) {
                oldValue.replaceWith(value);
                return;
            }
        }
        list.put(value.getName(), value);
    }

    @Override
    public boolean hasResourceValue(ResourceType type, String name) {
        Map<String, ResourceValue> map = this.mResourceItems.get(type);
        return map != null && map.containsKey(name);
    }

    @Override
    public ResourceValue getValue(ResourceType type, String name) {
        Map<String, ResourceValue> list = this.mResourceItems.get(type);
        if (list != null) {
            return list.get(name);
        }
        return null;
    }
}

