/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.cvsstatuses.CvsStatusProvider;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.netbeans.lib.cvsclient.admin.AdminReader;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class AdminReaderOnCache
implements IAdminReader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderOnCache");
    private final IAdminReader ourStandardAdminReader = new AdminReader(CvsApplicationLevelConfiguration.getCharset());
    private final CvsEntriesManager myCvsEntriesManager = CvsEntriesManager.getInstance();

    public Entry getEntry(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) throws IOException {
        ProgressManager.checkCanceled();
        this.setProgressText(CvsBundle.message((String)"progress.text.scanning.directory", (Object[])new Object[]{cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject.getParent()).getAbsolutePath()}));
        File file = cvsFileSystem.getAdminFileSystem().getFile(fileObject);
        Entry result = this.myCvsEntriesManager.getEntryFor(CvsVfsUtil.findFileByIoFile(file.getParentFile()), file.getName());
        if (result == null) {
            return null;
        }
        try {
            return (Entry)result.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public Collection<Entry> getEntries(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        this.setProgressText(CvsBundle.message((String)"progress.text.scanning.directory", (Object[])new Object[]{cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject).getAbsolutePath()}));
        ProgressManager.checkCanceled();
        File parent = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        Collection<Entry> entries = this.myCvsEntriesManager.getEntriesIn(CvsVfsUtil.findFileByIoFile(parent));
        ArrayList<Entry> copy = new ArrayList<Entry>();
        for (Entry entry : entries) {
            try {
                copy.add((Entry)entry.clone());
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
            }
        }
        return copy;
    }

    private void setProgressText(String text) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            return;
        }
        progressIndicator.setText2(text);
    }

    public String getRepositoryForDirectory(DirectoryObject directoryObject, String repository, ICvsFileSystem cvsFileSystem) throws IOException {
        File parent = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(parent);
        String repositoryDerectory = this.myCvsEntriesManager.getRepositoryFor(virtualFile);
        if (repositoryDerectory == null) {
            String parentRepository = this.myCvsEntriesManager.getRepositoryFor(virtualFile.getParent());
            repositoryDerectory = parentRepository + "/" + virtualFile.getName();
        }
        if (StringUtil.startsWithChar((CharSequence)repositoryDerectory, (char)'/')) {
            return repositoryDerectory;
        }
        return FileUtils.ensureTrailingSlash((String)repository) + repositoryDerectory;
    }

    public String getStickyTagForDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        File parent = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        return this.myCvsEntriesManager.getStickyTagFor(CvsVfsUtil.findFileByIoFile(parent));
    }

    public boolean hasCvsDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        return this.ourStandardAdminReader.hasCvsDirectory(directoryObject, cvsFileSystem);
    }

    public boolean isModified(FileObject fileObject, Date entryLastModified, ICvsFileSystem cvsFileSystem) {
        File file = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(file);
        if (virtualFile == null) {
            return !CvsStatusProvider.timeStampsAreEqual(entryLastModified.getTime(), file.lastModified());
        }
        return !CvsStatusProvider.timeStampsAreEqual(entryLastModified.getTime(), CvsVfsUtil.getTimeStamp(virtualFile));
    }

    public boolean isStatic(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        return this.ourStandardAdminReader.isStatic(directoryObject, cvsFileSystem);
    }
}

