/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystem {
    protected VirtualFileSystem() {
    }

    @NonNls
    @NotNull
    public abstract String getProtocol();

    @Nullable
    public abstract VirtualFile findFileByPath(@NotNull @NonNls String var1);

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/VirtualFileSystem", "extractPresentableUrl"));
        }
        String string = path.replace('/', File.separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileSystem", "extractPresentableUrl"));
        }
        return string;
    }

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    protected abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    protected abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    public boolean isCaseSensitive() {
        return true;
    }
}

