/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.io.CompressedAppendableFile;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.RandomAccessFileWithLengthAndSizeTracking;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMapValueStorage {
    @Nullable
    private RAReader myCompactionModeReader;
    private volatile long mySize;
    private final String myPath;
    private static final FileAccessorCache<String, RandomAccessFileWithLengthAndSizeTracking> ourRandomAccessFileCache = new FileAccessorCache<String, RandomAccessFileWithLengthAndSizeTracking>(20, 40){

        @Override
        protected RandomAccessFileWithLengthAndSizeTracking createAccessor(String path) throws IOException {
            return new RandomAccessFileWithLengthAndSizeTracking(path);
        }

        @Override
        protected void disposeAccessor(RandomAccessFileWithLengthAndSizeTracking fileAccessor) {
            this.disposeCloseable(fileAccessor);
        }
    };
    private static final boolean useSingleFileDescriptor = SystemProperties.getBooleanProperty("idea.use.single.file.descriptor.for.persistent.hash.map", true);
    private static final FileAccessorCache<String, DataOutputStream> ourAppendersCache = new FileAccessorCache<String, DataOutputStream>(10, 20){

        @Override
        protected DataOutputStream createAccessor(String path) throws IOException {
            OutputStream out = useSingleFileDescriptor ? new OutputStreamOverRandomAccessFileCache(path) : new FileOutputStream(path, true);
            return new DataOutputStream(new BufferedOutputStream(out));
        }

        @Override
        protected void disposeAccessor(DataOutputStream fileAccessor) {
            this.disposeCloseable(fileAccessor);
        }
    };
    private static final FileAccessorCache<String, RAReader> ourReadersCache = new FileAccessorCache<String, RAReader>(10, 20){

        @Override
        protected RAReader createAccessor(String path) throws IOException {
            return useSingleFileDescriptor ? new ReaderOverRandomAccessFileCache(path) : new FileReader(new File(path));
        }

        @Override
        protected void disposeAccessor(RAReader fileAccessor) {
            fileAccessor.dispose();
        }
    };
    private final CompressedAppendableFile myCompressedAppendableFile;
    public static final boolean COMPRESSION_ENABLED = SystemProperties.getBooleanProperty("idea.compression.enabled", true);
    private static final boolean ourDumpChunkRemovalTime = SystemProperties.getBooleanProperty("idea.phmp.dump.chunk.removal.time", false);

    public void dispose() {
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.dispose();
        }
        if (this.mySize < 0L) assert (false);
        ourReadersCache.remove(this.myPath);
        ourAppendersCache.remove(this.myPath);
        ourRandomAccessFileCache.remove(this.myPath);
        if (this.myCompactionModeReader != null) {
            this.myCompactionModeReader.dispose();
            this.myCompactionModeReader = null;
        }
    }

    private static class OutputStreamOverRandomAccessFileCache
    extends OutputStream {
        private final String myPath;

        public OutputStreamOverRandomAccessFileCache(String path) throws IOException {
            this.myPath = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            FileAccessorCache.Handle fileAccessor = ourRandomAccessFileCache.get(this.myPath);
            RandomAccessFileWithLengthAndSizeTracking file = (RandomAccessFileWithLengthAndSizeTracking)fileAccessor.get();
            try {
                file.seek(file.length());
                file.write(b, off, len);
            }
            finally {
                fileAccessor.release();
            }
        }

        @Override
        public void write(int b) throws IOException {
            byte[] r = new byte[]{(byte)(b & 0xFF)};
            this.write(r);
        }
    }

    private static class FileReader
    implements RAReader {
        private final RandomAccessFile myFile;

        private FileReader(File file) {
            try {
                this.myFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void dispose() {
            try {
                this.myFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReaderOverRandomAccessFileCache
    implements RAReader {
        private String myPath;

        private ReaderOverRandomAccessFileCache(String path) {
            this.myPath = path;
        }

        @Override
        public void dispose() {
        }
    }

    private static interface RAReader {
        public void dispose();
    }
}

