/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.output;

import java.io.File;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u0003!IQ!\u0001\u0003\u0005\u0019\u0001I\u0012\u0001'\u0001\"$%1\u0001\"A\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004%\u0019\u0001RA\u0007\u00021\rI1\u0001c\u0002\u000e\u0003a!\u0011kA\u0001\t\n\u0015\"Aa\u0003\u0005\b\u001b\u0005AB!\n\u0003\u0005\u0017!=Q\"\u0001\r\u0004K\u0011!1\u0002\u0003\u0005\u000e\u0003a\u0019\u0011f\u0002\u0003B\u0011!\u001dQ\"\u0001\r\u0005#\u000e\tQ\u0001A\u0015\u000b\t-C\u0001RA\u0007\u00021\r\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003*\u001b\u0011Y\u0005\u0002C\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00031\u0007\t6\u0001B\u0003\u0001\u001b\t!a\u0001#\u0004"}, strings={"Lorg/jetbrains/kotlin/backend/common/output/SimpleOutputBinaryFile;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "sourceFiles", "", "Ljava/io/File;", "relativePath", "", "content", "", "(Ljava/util/List;Ljava/lang/String;[B)V", "getRelativePath", "()Ljava/lang/String;", "getSourceFiles", "()Ljava/util/List;", "asByteArray", "asText", "toString"}, moduleName="kotlin-compiler")
public final class SimpleOutputBinaryFile
implements OutputFile {
    @NotNull
    private final List<File> sourceFiles;
    @NotNull
    private final String relativePath;
    private final byte[] content;

    @Override
    @NotNull
    public byte[] asByteArray() {
        return this.content;
    }

    @Override
    @NotNull
    public String asText() {
        return StringsKt.String(this.content);
    }

    @NotNull
    public String toString() {
        return this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
    }

    @Override
    @NotNull
    public List<File> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    public SimpleOutputBinaryFile(@NotNull List<? extends File> sourceFiles, @NotNull String relativePath, @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull(sourceFiles, "sourceFiles");
        Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
        Intrinsics.checkParameterIsNotNull(content, "content");
        this.sourceFiles = sourceFiles;
        this.relativePath = relativePath;
        this.content = content;
    }
}

